// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.serde

import aws.sdk.kotlin.services.snowball.model.GetSnowballUsageResponse
import aws.sdk.kotlin.services.snowball.model.SnowballException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetSnowballUsageOperationDeserializer: HttpDeserialize<GetSnowballUsageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSnowballUsageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSnowballUsageError(context, call)
        }
        val builder = GetSnowballUsageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSnowballUsageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSnowballUsageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SnowballException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SnowballException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSnowballUsageOperationBody(builder: GetSnowballUsageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SNOWBALLLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("SnowballLimit"))
    val SNOWBALLSINUSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("SnowballsInUse"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SNOWBALLLIMIT_DESCRIPTOR)
        field(SNOWBALLSINUSE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SNOWBALLLIMIT_DESCRIPTOR.index -> builder.snowballLimit = deserializeInt()
                SNOWBALLSINUSE_DESCRIPTOR.index -> builder.snowballsInUse = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
