// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.serde

import aws.sdk.kotlin.services.snowball.model.GetJobUnlockCodeResponse
import aws.sdk.kotlin.services.snowball.model.SnowballException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetJobUnlockCodeOperationDeserializer: HttpDeserialize<GetJobUnlockCodeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetJobUnlockCodeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetJobUnlockCodeError(context, call)
        }
        val builder = GetJobUnlockCodeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetJobUnlockCodeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetJobUnlockCodeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SnowballException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidJobStateException" -> InvalidJobStateExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidResourceException" -> InvalidResourceExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SnowballException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetJobUnlockCodeOperationBody(builder: GetJobUnlockCodeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val UNLOCKCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UnlockCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(UNLOCKCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                UNLOCKCODE_DESCRIPTOR.index -> builder.unlockCode = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
