// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.serde

import aws.sdk.kotlin.services.snowball.model.CreateClusterResponse
import aws.sdk.kotlin.services.snowball.model.JobListEntry
import aws.sdk.kotlin.services.snowball.model.SnowballException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateClusterOperationDeserializer: HttpDeserialize<CreateClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateClusterError(context, call)
        }
        val builder = CreateClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateClusterError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SnowballException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSRequestFailedException" -> KmsRequestFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "Ec2RequestFailedException" -> Ec2RequestFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidResourceException" -> InvalidResourceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInputCombinationException" -> InvalidInputCombinationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SnowballException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterOperationBody(builder: CreateClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterId"))
    val JOBLISTENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("JobListEntries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERID_DESCRIPTOR)
        field(JOBLISTENTRIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERID_DESCRIPTOR.index -> builder.clusterId = deserializeString()
                JOBLISTENTRIES_DESCRIPTOR.index -> builder.jobListEntries =
                    deserializer.deserializeList(JOBLISTENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<JobListEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeJobListEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
