// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.serde

import aws.sdk.kotlin.services.snowball.model.CancelJobResponse
import aws.sdk.kotlin.services.snowball.model.SnowballException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CancelJobOperationDeserializer: HttpDeserialize<CancelJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CancelJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCancelJobError(context, call)
        }
        val builder = CancelJobResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCancelJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SnowballException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSRequestFailedException" -> KmsRequestFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidJobStateException" -> InvalidJobStateExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidResourceException" -> InvalidResourceExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SnowballException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
