// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.paginators

import aws.sdk.kotlin.services.snowball.SnowballClient
import aws.sdk.kotlin.services.snowball.model.Address
import aws.sdk.kotlin.services.snowball.model.ClusterListEntry
import aws.sdk.kotlin.services.snowball.model.CompatibleImage
import aws.sdk.kotlin.services.snowball.model.DescribeAddressesRequest
import aws.sdk.kotlin.services.snowball.model.DescribeAddressesResponse
import aws.sdk.kotlin.services.snowball.model.JobListEntry
import aws.sdk.kotlin.services.snowball.model.ListClusterJobsRequest
import aws.sdk.kotlin.services.snowball.model.ListClusterJobsResponse
import aws.sdk.kotlin.services.snowball.model.ListClustersRequest
import aws.sdk.kotlin.services.snowball.model.ListClustersResponse
import aws.sdk.kotlin.services.snowball.model.ListCompatibleImagesRequest
import aws.sdk.kotlin.services.snowball.model.ListCompatibleImagesResponse
import aws.sdk.kotlin.services.snowball.model.ListJobsRequest
import aws.sdk.kotlin.services.snowball.model.ListJobsResponse
import aws.sdk.kotlin.services.snowball.model.ListLongTermPricingRequest
import aws.sdk.kotlin.services.snowball.model.ListLongTermPricingResponse
import aws.sdk.kotlin.services.snowball.model.ListPickupLocationsRequest
import aws.sdk.kotlin.services.snowball.model.ListPickupLocationsResponse
import aws.sdk.kotlin.services.snowball.model.LongTermPricingListEntry
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAddressesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAddressesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAddressesResponse]
 */
public fun SnowballClient.describeAddressesPaginated(initialRequest: DescribeAddressesRequest = DescribeAddressesRequest { }): Flow<DescribeAddressesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAddressesPaginated.describeAddresses(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAddressesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAddressesResponse]
 */
public fun SnowballClient.describeAddressesPaginated(block: DescribeAddressesRequest.Builder.() -> Unit): Flow<DescribeAddressesResponse> =
    describeAddressesPaginated(DescribeAddressesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAddressesPaginated]
 * to access the nested member [Address]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Address]
 */
@JvmName("describeAddressesResponseAddress")
public fun Flow<DescribeAddressesResponse>.addresses(): Flow<Address> =
    transform() { response ->
        response.addresses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClusterJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClusterJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterJobsResponse]
 */
public fun SnowballClient.listClusterJobsPaginated(initialRequest: ListClusterJobsRequest): Flow<ListClusterJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClusterJobsPaginated.listClusterJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClusterJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterJobsResponse]
 */
public fun SnowballClient.listClusterJobsPaginated(block: ListClusterJobsRequest.Builder.() -> Unit): Flow<ListClusterJobsResponse> =
    listClusterJobsPaginated(ListClusterJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClusterJobsPaginated]
 * to access the nested member [JobListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobListEntry]
 */
@JvmName("listClusterJobsResponseJobListEntry")
public fun Flow<ListClusterJobsResponse>.jobListEntries(): Flow<JobListEntry> =
    transform() { response ->
        response.jobListEntries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun SnowballClient.listClustersPaginated(initialRequest: ListClustersRequest = ListClustersRequest { }): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun SnowballClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [ClusterListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterListEntry]
 */
@JvmName("listClustersResponseClusterListEntry")
public fun Flow<ListClustersResponse>.clusterListEntries(): Flow<ClusterListEntry> =
    transform() { response ->
        response.clusterListEntries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCompatibleImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCompatibleImagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCompatibleImagesResponse]
 */
public fun SnowballClient.listCompatibleImagesPaginated(initialRequest: ListCompatibleImagesRequest = ListCompatibleImagesRequest { }): Flow<ListCompatibleImagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCompatibleImagesPaginated.listCompatibleImages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCompatibleImagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCompatibleImagesResponse]
 */
public fun SnowballClient.listCompatibleImagesPaginated(block: ListCompatibleImagesRequest.Builder.() -> Unit): Flow<ListCompatibleImagesResponse> =
    listCompatibleImagesPaginated(ListCompatibleImagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCompatibleImagesPaginated]
 * to access the nested member [CompatibleImage]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CompatibleImage]
 */
@JvmName("listCompatibleImagesResponseCompatibleImage")
public fun Flow<ListCompatibleImagesResponse>.compatibleImages(): Flow<CompatibleImage> =
    transform() { response ->
        response.compatibleImages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun SnowballClient.listJobsPaginated(initialRequest: ListJobsRequest = ListJobsRequest { }): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun SnowballClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsPaginated]
 * to access the nested member [JobListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobListEntry]
 */
@JvmName("listJobsResponseJobListEntry")
public fun Flow<ListJobsResponse>.jobListEntries(): Flow<JobListEntry> =
    transform() { response ->
        response.jobListEntries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLongTermPricingResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLongTermPricingRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLongTermPricingResponse]
 */
public fun SnowballClient.listLongTermPricingPaginated(initialRequest: ListLongTermPricingRequest = ListLongTermPricingRequest { }): Flow<ListLongTermPricingResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLongTermPricingPaginated.listLongTermPricing(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLongTermPricingResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLongTermPricingResponse]
 */
public fun SnowballClient.listLongTermPricingPaginated(block: ListLongTermPricingRequest.Builder.() -> Unit): Flow<ListLongTermPricingResponse> =
    listLongTermPricingPaginated(ListLongTermPricingRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLongTermPricingPaginated]
 * to access the nested member [LongTermPricingListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LongTermPricingListEntry]
 */
@JvmName("listLongTermPricingResponseLongTermPricingListEntry")
public fun Flow<ListLongTermPricingResponse>.longTermPricingEntries(): Flow<LongTermPricingListEntry> =
    transform() { response ->
        response.longTermPricingEntries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPickupLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPickupLocationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPickupLocationsResponse]
 */
public fun SnowballClient.listPickupLocationsPaginated(initialRequest: ListPickupLocationsRequest = ListPickupLocationsRequest { }): Flow<ListPickupLocationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPickupLocationsPaginated.listPickupLocations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPickupLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPickupLocationsResponse]
 */
public fun SnowballClient.listPickupLocationsPaginated(block: ListPickupLocationsRequest.Builder.() -> Unit): Flow<ListPickupLocationsResponse> =
    listPickupLocationsPaginated(ListPickupLocationsRequest.Builder().apply(block).build())
