// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model



/**
 * Each `S3Resource` object represents an Amazon S3 bucket that your transferred data will be exported from or imported into. For export jobs, this object can have an optional `KeyRange` value. The length of the range is defined at job creation, and has either an inclusive `BeginMarker`, an inclusive `EndMarker`, or both. Ranges are UTF-8 binary sorted.
 */
public class S3Resource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Amazon S3 bucket.
     */
    public val bucketArn: kotlin.String? = builder.bucketArn
    /**
     * For export jobs, you can provide an optional `KeyRange` within a specific Amazon S3 bucket. The length of the range is defined at job creation, and has either an inclusive `BeginMarker`, an inclusive `EndMarker`, or both. Ranges are UTF-8 binary sorted.
     */
    public val keyRange: aws.sdk.kotlin.services.snowball.model.KeyRange? = builder.keyRange
    /**
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System).
     */
    public val targetOnDeviceServices: List<TargetOnDeviceService>? = builder.targetOnDeviceServices

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.S3Resource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Resource(")
        append("bucketArn=$bucketArn,")
        append("keyRange=$keyRange,")
        append("targetOnDeviceServices=$targetOnDeviceServices")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn?.hashCode() ?: 0
        result = 31 * result + (keyRange?.hashCode() ?: 0)
        result = 31 * result + (targetOnDeviceServices?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Resource

        if (bucketArn != other.bucketArn) return false
        if (keyRange != other.keyRange) return false
        if (targetOnDeviceServices != other.targetOnDeviceServices) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.S3Resource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Amazon S3 bucket.
         */
        public var bucketArn: kotlin.String? = null
        /**
         * For export jobs, you can provide an optional `KeyRange` within a specific Amazon S3 bucket. The length of the range is defined at job creation, and has either an inclusive `BeginMarker`, an inclusive `EndMarker`, or both. Ranges are UTF-8 binary sorted.
         */
        public var keyRange: aws.sdk.kotlin.services.snowball.model.KeyRange? = null
        /**
         * Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System).
         */
        public var targetOnDeviceServices: List<TargetOnDeviceService>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.S3Resource) : this() {
            this.bucketArn = x.bucketArn
            this.keyRange = x.keyRange
            this.targetOnDeviceServices = x.targetOnDeviceServices
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.S3Resource = S3Resource(this)

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.KeyRange] inside the given [block]
         */
        public fun keyRange(block: aws.sdk.kotlin.services.snowball.model.KeyRange.Builder.() -> kotlin.Unit) {
            this.keyRange = aws.sdk.kotlin.services.snowball.model.KeyRange.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
