// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model



/**
 * Contains an array of Amazon Web Services resource objects. Each object represents an Amazon S3 bucket, an Lambda function, or an Amazon Machine Image (AMI) based on Amazon EC2 that is associated with a particular job.
 */
public class JobResource private constructor(builder: Builder) {
    /**
     * The Amazon Machine Images (AMIs) associated with this job.
     */
    public val ec2AmiResources: List<Ec2AmiResource>? = builder.ec2AmiResources
    /**
     * The Python-language Lambda functions for this job.
     */
    public val lambdaResources: List<LambdaResource>? = builder.lambdaResources
    /**
     * An array of `S3Resource` objects.
     */
    public val s3Resources: List<S3Resource>? = builder.s3Resources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.JobResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobResource(")
        append("ec2AmiResources=$ec2AmiResources,")
        append("lambdaResources=$lambdaResources,")
        append("s3Resources=$s3Resources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ec2AmiResources?.hashCode() ?: 0
        result = 31 * result + (lambdaResources?.hashCode() ?: 0)
        result = 31 * result + (s3Resources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobResource

        if (ec2AmiResources != other.ec2AmiResources) return false
        if (lambdaResources != other.lambdaResources) return false
        if (s3Resources != other.s3Resources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.JobResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Machine Images (AMIs) associated with this job.
         */
        public var ec2AmiResources: List<Ec2AmiResource>? = null
        /**
         * The Python-language Lambda functions for this job.
         */
        public var lambdaResources: List<LambdaResource>? = null
        /**
         * An array of `S3Resource` objects.
         */
        public var s3Resources: List<S3Resource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.JobResource) : this() {
            this.ec2AmiResources = x.ec2AmiResources
            this.lambdaResources = x.lambdaResources
            this.s3Resources = x.s3Resources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.JobResource = JobResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
