// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a specific job including shipping information, job status, and other important metadata. This information is returned as a part of the response syntax of the `DescribeJob` action.
 */
public class JobMetadata private constructor(builder: Builder) {
    /**
     * The ID for the address that you want the Snow device shipped to.
     */
    public val addressId: kotlin.String? = builder.addressId
    /**
     * The 39-character ID for the cluster, for example `CID123e4567-e89b-12d3-a456-426655440000`.
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * The creation date for this job.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A value that defines the real-time status of a Snow device's data transfer while the device is at Amazon Web Services. This data is only available while a job has a `JobState` value of `InProgress`, for both import and export jobs.
     */
    public val dataTransferProgress: aws.sdk.kotlin.services.snowball.model.DataTransfer? = builder.dataTransferProgress
    /**
     * The description of the job, provided at job creation.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The container for `SnowconeDeviceConfiguration`.
     */
    public val deviceConfiguration: aws.sdk.kotlin.services.snowball.model.DeviceConfiguration? = builder.deviceConfiguration
    /**
     * The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field is not supported in most regions.
     */
    public val forwardingAddressId: kotlin.String? = builder.forwardingAddressId
    /**
     * The highest impact level of data that will be stored or processed on the device, provided at job creation.
     */
    public val impactLevel: aws.sdk.kotlin.services.snowball.model.ImpactLevel? = builder.impactLevel
    /**
     * The automatically generated ID for a job, for example `JID123e4567-e89b-12d3-a456-426655440000`.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snow device for your job part is being delivered to you.
     */
    public val jobLogInfo: aws.sdk.kotlin.services.snowball.model.JobLogs? = builder.jobLogInfo
    /**
     * The current status of the jobs.
     */
    public val jobState: aws.sdk.kotlin.services.snowball.model.JobState? = builder.jobState
    /**
     * The type of job.
     */
    public val jobType: aws.sdk.kotlin.services.snowball.model.JobType? = builder.jobType
    /**
     * The Amazon Resource Name (ARN) for the Key Management Service (KMS) key associated with this job. This ARN was created using the [CreateKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html) API action in KMS.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The ID of the long-term pricing type for the device.
     */
    public val longTermPricingId: kotlin.String? = builder.longTermPricingId
    /**
     * The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The `Notification` object is returned as a part of the response syntax of the `DescribeJob` action in the `JobMetadata` data type.
     */
    public val notification: aws.sdk.kotlin.services.snowball.model.Notification? = builder.notification
    /**
     * Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.
     */
    public val onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = builder.onDeviceServiceConfiguration
    /**
     * Information identifying the person picking up the device.
     */
    public val pickupDetails: aws.sdk.kotlin.services.snowball.model.PickupDetails? = builder.pickupDetails
    /**
     * Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to `INSTALLED_AUTOSTART`, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     */
    public val remoteManagement: aws.sdk.kotlin.services.snowball.model.RemoteManagement? = builder.remoteManagement
    /**
     * An array of `S3Resource` objects. Each `S3Resource` object represents an Amazon S3 bucket that your transferred data will be exported from or imported into.
     */
    public val resources: aws.sdk.kotlin.services.snowball.model.JobResource? = builder.resources
    /**
     * The role ARN associated with this job. This ARN was created using the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) API action in Identity and Access Management.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
     */
    public val shippingDetails: aws.sdk.kotlin.services.snowball.model.ShippingDetails? = builder.shippingDetails
    /**
     * The Snow device capacity preference for this job, specified at job creation. In US regions, you can choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
     *
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
     */
    public val snowballCapacityPreference: aws.sdk.kotlin.services.snowball.model.SnowballCapacity? = builder.snowballCapacityPreference
    /**
     * Unique ID associated with a device.
     */
    public val snowballId: kotlin.String? = builder.snowballId
    /**
     * The type of device used with this job.
     */
    public val snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = builder.snowballType
    /**
     * The metadata associated with the tax documents required in your Amazon Web Services Region.
     */
    public val taxDocuments: aws.sdk.kotlin.services.snowball.model.TaxDocuments? = builder.taxDocuments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.JobMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobMetadata(")
        append("addressId=$addressId,")
        append("clusterId=$clusterId,")
        append("creationDate=$creationDate,")
        append("dataTransferProgress=$dataTransferProgress,")
        append("description=$description,")
        append("deviceConfiguration=$deviceConfiguration,")
        append("forwardingAddressId=$forwardingAddressId,")
        append("impactLevel=$impactLevel,")
        append("jobId=$jobId,")
        append("jobLogInfo=$jobLogInfo,")
        append("jobState=$jobState,")
        append("jobType=$jobType,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("longTermPricingId=$longTermPricingId,")
        append("notification=$notification,")
        append("onDeviceServiceConfiguration=$onDeviceServiceConfiguration,")
        append("pickupDetails=$pickupDetails,")
        append("remoteManagement=$remoteManagement,")
        append("resources=$resources,")
        append("roleArn=$roleArn,")
        append("shippingDetails=$shippingDetails,")
        append("snowballCapacityPreference=$snowballCapacityPreference,")
        append("snowballId=$snowballId,")
        append("snowballType=$snowballType,")
        append("taxDocuments=$taxDocuments")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressId?.hashCode() ?: 0
        result = 31 * result + (clusterId?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (dataTransferProgress?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (forwardingAddressId?.hashCode() ?: 0)
        result = 31 * result + (impactLevel?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobLogInfo?.hashCode() ?: 0)
        result = 31 * result + (jobState?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (longTermPricingId?.hashCode() ?: 0)
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (onDeviceServiceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pickupDetails?.hashCode() ?: 0)
        result = 31 * result + (remoteManagement?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (shippingDetails?.hashCode() ?: 0)
        result = 31 * result + (snowballCapacityPreference?.hashCode() ?: 0)
        result = 31 * result + (snowballId?.hashCode() ?: 0)
        result = 31 * result + (snowballType?.hashCode() ?: 0)
        result = 31 * result + (taxDocuments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobMetadata

        if (addressId != other.addressId) return false
        if (clusterId != other.clusterId) return false
        if (creationDate != other.creationDate) return false
        if (dataTransferProgress != other.dataTransferProgress) return false
        if (description != other.description) return false
        if (deviceConfiguration != other.deviceConfiguration) return false
        if (forwardingAddressId != other.forwardingAddressId) return false
        if (impactLevel != other.impactLevel) return false
        if (jobId != other.jobId) return false
        if (jobLogInfo != other.jobLogInfo) return false
        if (jobState != other.jobState) return false
        if (jobType != other.jobType) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (longTermPricingId != other.longTermPricingId) return false
        if (notification != other.notification) return false
        if (onDeviceServiceConfiguration != other.onDeviceServiceConfiguration) return false
        if (pickupDetails != other.pickupDetails) return false
        if (remoteManagement != other.remoteManagement) return false
        if (resources != other.resources) return false
        if (roleArn != other.roleArn) return false
        if (shippingDetails != other.shippingDetails) return false
        if (snowballCapacityPreference != other.snowballCapacityPreference) return false
        if (snowballId != other.snowballId) return false
        if (snowballType != other.snowballType) return false
        if (taxDocuments != other.taxDocuments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.JobMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the address that you want the Snow device shipped to.
         */
        public var addressId: kotlin.String? = null
        /**
         * The 39-character ID for the cluster, for example `CID123e4567-e89b-12d3-a456-426655440000`.
         */
        public var clusterId: kotlin.String? = null
        /**
         * The creation date for this job.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A value that defines the real-time status of a Snow device's data transfer while the device is at Amazon Web Services. This data is only available while a job has a `JobState` value of `InProgress`, for both import and export jobs.
         */
        public var dataTransferProgress: aws.sdk.kotlin.services.snowball.model.DataTransfer? = null
        /**
         * The description of the job, provided at job creation.
         */
        public var description: kotlin.String? = null
        /**
         * The container for `SnowconeDeviceConfiguration`.
         */
        public var deviceConfiguration: aws.sdk.kotlin.services.snowball.model.DeviceConfiguration? = null
        /**
         * The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field is not supported in most regions.
         */
        public var forwardingAddressId: kotlin.String? = null
        /**
         * The highest impact level of data that will be stored or processed on the device, provided at job creation.
         */
        public var impactLevel: aws.sdk.kotlin.services.snowball.model.ImpactLevel? = null
        /**
         * The automatically generated ID for a job, for example `JID123e4567-e89b-12d3-a456-426655440000`.
         */
        public var jobId: kotlin.String? = null
        /**
         * Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snow device for your job part is being delivered to you.
         */
        public var jobLogInfo: aws.sdk.kotlin.services.snowball.model.JobLogs? = null
        /**
         * The current status of the jobs.
         */
        public var jobState: aws.sdk.kotlin.services.snowball.model.JobState? = null
        /**
         * The type of job.
         */
        public var jobType: aws.sdk.kotlin.services.snowball.model.JobType? = null
        /**
         * The Amazon Resource Name (ARN) for the Key Management Service (KMS) key associated with this job. This ARN was created using the [CreateKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html) API action in KMS.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The ID of the long-term pricing type for the device.
         */
        public var longTermPricingId: kotlin.String? = null
        /**
         * The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The `Notification` object is returned as a part of the response syntax of the `DescribeJob` action in the `JobMetadata` data type.
         */
        public var notification: aws.sdk.kotlin.services.snowball.model.Notification? = null
        /**
         * Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.
         */
        public var onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = null
        /**
         * Information identifying the person picking up the device.
         */
        public var pickupDetails: aws.sdk.kotlin.services.snowball.model.PickupDetails? = null
        /**
         * Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to `INSTALLED_AUTOSTART`, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
         */
        public var remoteManagement: aws.sdk.kotlin.services.snowball.model.RemoteManagement? = null
        /**
         * An array of `S3Resource` objects. Each `S3Resource` object represents an Amazon S3 bucket that your transferred data will be exported from or imported into.
         */
        public var resources: aws.sdk.kotlin.services.snowball.model.JobResource? = null
        /**
         * The role ARN associated with this job. This ARN was created using the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) API action in Identity and Access Management.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
         */
        public var shippingDetails: aws.sdk.kotlin.services.snowball.model.ShippingDetails? = null
        /**
         * The Snow device capacity preference for this job, specified at job creation. In US regions, you can choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.
         *
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
         */
        public var snowballCapacityPreference: aws.sdk.kotlin.services.snowball.model.SnowballCapacity? = null
        /**
         * Unique ID associated with a device.
         */
        public var snowballId: kotlin.String? = null
        /**
         * The type of device used with this job.
         */
        public var snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = null
        /**
         * The metadata associated with the tax documents required in your Amazon Web Services Region.
         */
        public var taxDocuments: aws.sdk.kotlin.services.snowball.model.TaxDocuments? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.JobMetadata) : this() {
            this.addressId = x.addressId
            this.clusterId = x.clusterId
            this.creationDate = x.creationDate
            this.dataTransferProgress = x.dataTransferProgress
            this.description = x.description
            this.deviceConfiguration = x.deviceConfiguration
            this.forwardingAddressId = x.forwardingAddressId
            this.impactLevel = x.impactLevel
            this.jobId = x.jobId
            this.jobLogInfo = x.jobLogInfo
            this.jobState = x.jobState
            this.jobType = x.jobType
            this.kmsKeyArn = x.kmsKeyArn
            this.longTermPricingId = x.longTermPricingId
            this.notification = x.notification
            this.onDeviceServiceConfiguration = x.onDeviceServiceConfiguration
            this.pickupDetails = x.pickupDetails
            this.remoteManagement = x.remoteManagement
            this.resources = x.resources
            this.roleArn = x.roleArn
            this.shippingDetails = x.shippingDetails
            this.snowballCapacityPreference = x.snowballCapacityPreference
            this.snowballId = x.snowballId
            this.snowballType = x.snowballType
            this.taxDocuments = x.taxDocuments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.JobMetadata = JobMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.DataTransfer] inside the given [block]
         */
        public fun dataTransferProgress(block: aws.sdk.kotlin.services.snowball.model.DataTransfer.Builder.() -> kotlin.Unit) {
            this.dataTransferProgress = aws.sdk.kotlin.services.snowball.model.DataTransfer.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.DeviceConfiguration] inside the given [block]
         */
        public fun deviceConfiguration(block: aws.sdk.kotlin.services.snowball.model.DeviceConfiguration.Builder.() -> kotlin.Unit) {
            this.deviceConfiguration = aws.sdk.kotlin.services.snowball.model.DeviceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.JobLogs] inside the given [block]
         */
        public fun jobLogInfo(block: aws.sdk.kotlin.services.snowball.model.JobLogs.Builder.() -> kotlin.Unit) {
            this.jobLogInfo = aws.sdk.kotlin.services.snowball.model.JobLogs.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.Notification] inside the given [block]
         */
        public fun notification(block: aws.sdk.kotlin.services.snowball.model.Notification.Builder.() -> kotlin.Unit) {
            this.notification = aws.sdk.kotlin.services.snowball.model.Notification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration] inside the given [block]
         */
        public fun onDeviceServiceConfiguration(block: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.Builder.() -> kotlin.Unit) {
            this.onDeviceServiceConfiguration = aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.PickupDetails] inside the given [block]
         */
        public fun pickupDetails(block: aws.sdk.kotlin.services.snowball.model.PickupDetails.Builder.() -> kotlin.Unit) {
            this.pickupDetails = aws.sdk.kotlin.services.snowball.model.PickupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.JobResource] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.snowball.model.JobResource.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.snowball.model.JobResource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.ShippingDetails] inside the given [block]
         */
        public fun shippingDetails(block: aws.sdk.kotlin.services.snowball.model.ShippingDetails.Builder.() -> kotlin.Unit) {
            this.shippingDetails = aws.sdk.kotlin.services.snowball.model.ShippingDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.TaxDocuments] inside the given [block]
         */
        public fun taxDocuments(block: aws.sdk.kotlin.services.snowball.model.TaxDocuments.Builder.() -> kotlin.Unit) {
            this.taxDocuments = aws.sdk.kotlin.services.snowball.model.TaxDocuments.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
