// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model



/**
 * Contains job logs. Whenever a Snow device is used to import data into or export data out of Amazon S3, you'll have the option of downloading a PDF job report. Job logs are returned as a part of the response syntax of the `DescribeJob` action in the `JobMetadata` data type. The job logs can be accessed for up to 60 minutes after this request has been made. To access any of the job logs after 60 minutes have passed, you'll have to make another call to the `DescribeJob` action.
 *
 * For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snow device for your job part is being delivered to you.
 *
 * The job report provides you insight into the state of your Amazon S3 data transfer. The report includes details about your job or job part for your records.
 *
 * For deeper visibility into the status of your transferred objects, you can look at the two associated logs: a success log and a failure log. The logs are saved in comma-separated value (CSV) format, and the name of each log includes the ID of the job or job part that the log describes.
 */
public class JobLogs private constructor(builder: Builder) {
    /**
     * A link to an Amazon S3 presigned URL where the job completion report is located.
     */
    public val jobCompletionReportUri: kotlin.String? = builder.jobCompletionReportUri
    /**
     * A link to an Amazon S3 presigned URL where the job failure log is located.
     */
    public val jobFailureLogUri: kotlin.String? = builder.jobFailureLogUri
    /**
     * A link to an Amazon S3 presigned URL where the job success log is located.
     */
    public val jobSuccessLogUri: kotlin.String? = builder.jobSuccessLogUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.JobLogs = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobLogs(")
        append("jobCompletionReportUri=$jobCompletionReportUri,")
        append("jobFailureLogUri=$jobFailureLogUri,")
        append("jobSuccessLogUri=$jobSuccessLogUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobCompletionReportUri?.hashCode() ?: 0
        result = 31 * result + (jobFailureLogUri?.hashCode() ?: 0)
        result = 31 * result + (jobSuccessLogUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobLogs

        if (jobCompletionReportUri != other.jobCompletionReportUri) return false
        if (jobFailureLogUri != other.jobFailureLogUri) return false
        if (jobSuccessLogUri != other.jobSuccessLogUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.JobLogs = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A link to an Amazon S3 presigned URL where the job completion report is located.
         */
        public var jobCompletionReportUri: kotlin.String? = null
        /**
         * A link to an Amazon S3 presigned URL where the job failure log is located.
         */
        public var jobFailureLogUri: kotlin.String? = null
        /**
         * A link to an Amazon S3 presigned URL where the job success log is located.
         */
        public var jobSuccessLogUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.JobLogs) : this() {
            this.jobCompletionReportUri = x.jobCompletionReportUri
            this.jobFailureLogUri = x.jobFailureLogUri
            this.jobSuccessLogUri = x.jobSuccessLogUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.JobLogs = JobLogs(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
