// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Each `JobListEntry` object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of an export job.
 */
public class JobListEntry private constructor(builder: Builder) {
    /**
     * The creation date for this job.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The optional description of this specific job, for example `Important Photos 2016-08-11`.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A value that indicates that this job is a main job. A main job represents a successful request to create an export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least one job part, and each job part is associated with a Snowball. It might take some time before the job parts associated with a particular main job are listed, because they are created after the main job is created.
     */
    public val isMaster: kotlin.Boolean = builder.isMaster
    /**
     * The automatically generated ID for a job, for example `JID123e4567-e89b-12d3-a456-426655440000`.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The current state of this job.
     */
    public val jobState: aws.sdk.kotlin.services.snowball.model.JobState? = builder.jobState
    /**
     * The type of job.
     */
    public val jobType: aws.sdk.kotlin.services.snowball.model.JobType? = builder.jobType
    /**
     * The type of device used with this job.
     */
    public val snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = builder.snowballType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.JobListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobListEntry(")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("isMaster=$isMaster,")
        append("jobId=$jobId,")
        append("jobState=$jobState,")
        append("jobType=$jobType,")
        append("snowballType=$snowballType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isMaster.hashCode())
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobState?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (snowballType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobListEntry

        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (isMaster != other.isMaster) return false
        if (jobId != other.jobId) return false
        if (jobState != other.jobState) return false
        if (jobType != other.jobType) return false
        if (snowballType != other.snowballType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.JobListEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The creation date for this job.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description of this specific job, for example `Important Photos 2016-08-11`.
         */
        public var description: kotlin.String? = null
        /**
         * A value that indicates that this job is a main job. A main job represents a successful request to create an export job. Main jobs aren't associated with any Snowballs. Instead, each main job will have at least one job part, and each job part is associated with a Snowball. It might take some time before the job parts associated with a particular main job are listed, because they are created after the main job is created.
         */
        public var isMaster: kotlin.Boolean = false
        /**
         * The automatically generated ID for a job, for example `JID123e4567-e89b-12d3-a456-426655440000`.
         */
        public var jobId: kotlin.String? = null
        /**
         * The current state of this job.
         */
        public var jobState: aws.sdk.kotlin.services.snowball.model.JobState? = null
        /**
         * The type of job.
         */
        public var jobType: aws.sdk.kotlin.services.snowball.model.JobType? = null
        /**
         * The type of device used with this job.
         */
        public var snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.JobListEntry) : this() {
            this.creationDate = x.creationDate
            this.description = x.description
            this.isMaster = x.isMaster
            this.jobId = x.jobId
            this.jobState = x.jobState
            this.jobType = x.jobType
            this.snowballType = x.snowballType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.JobListEntry = JobListEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
