// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model



/**
 * A JSON-formatted object that contains the IDs for an Amazon Machine Image (AMI), including the Amazon EC2-compatible AMI ID and the Snow device AMI ID. Each AMI has these two IDs to simplify identifying the AMI in both the Amazon Web Services Cloud and on the device.
 */
public class Ec2AmiResource private constructor(builder: Builder) {
    /**
     * The ID of the AMI in Amazon EC2.
     */
    public val amiId: kotlin.String = requireNotNull(builder.amiId) { "A non-null value must be provided for amiId" }
    /**
     * The ID of the AMI on the Snow device.
     */
    public val snowballAmiId: kotlin.String? = builder.snowballAmiId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.Ec2AmiResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2AmiResource(")
        append("amiId=$amiId,")
        append("snowballAmiId=$snowballAmiId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiId.hashCode()
        result = 31 * result + (snowballAmiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2AmiResource

        if (amiId != other.amiId) return false
        if (snowballAmiId != other.snowballAmiId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.Ec2AmiResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the AMI in Amazon EC2.
         */
        public var amiId: kotlin.String? = null
        /**
         * The ID of the AMI on the Snow device.
         */
        public var snowballAmiId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.Ec2AmiResource) : this() {
            this.amiId = x.amiId
            this.snowballAmiId = x.snowballAmiId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.Ec2AmiResource = Ec2AmiResource(this)

        internal fun correctErrors(): Builder {
            if (amiId == null) amiId = ""
            return this
        }
    }
}
