// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model



/**
 * Defines the real-time status of a Snow device's data transfer while the device is at Amazon Web Services. This data is only available while a job has a `JobState` value of `InProgress`, for both import and export jobs.
 */
public class DataTransfer private constructor(builder: Builder) {
    /**
     * The number of bytes transferred between a Snow device and Amazon S3.
     */
    public val bytesTransferred: kotlin.Long = builder.bytesTransferred
    /**
     * The number of objects transferred between a Snow device and Amazon S3.
     */
    public val objectsTransferred: kotlin.Long = builder.objectsTransferred
    /**
     * The total bytes of data for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.
     */
    public val totalBytes: kotlin.Long = builder.totalBytes
    /**
     * The total number of objects for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.
     */
    public val totalObjects: kotlin.Long = builder.totalObjects

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.DataTransfer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataTransfer(")
        append("bytesTransferred=$bytesTransferred,")
        append("objectsTransferred=$objectsTransferred,")
        append("totalBytes=$totalBytes,")
        append("totalObjects=$totalObjects")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesTransferred.hashCode()
        result = 31 * result + (objectsTransferred.hashCode())
        result = 31 * result + (totalBytes.hashCode())
        result = 31 * result + (totalObjects.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataTransfer

        if (bytesTransferred != other.bytesTransferred) return false
        if (objectsTransferred != other.objectsTransferred) return false
        if (totalBytes != other.totalBytes) return false
        if (totalObjects != other.totalObjects) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.DataTransfer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of bytes transferred between a Snow device and Amazon S3.
         */
        public var bytesTransferred: kotlin.Long = 0L
        /**
         * The number of objects transferred between a Snow device and Amazon S3.
         */
        public var objectsTransferred: kotlin.Long = 0L
        /**
         * The total bytes of data for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.
         */
        public var totalBytes: kotlin.Long = 0L
        /**
         * The total number of objects for a transfer between a Snow device and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.
         */
        public var totalObjects: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.DataTransfer) : this() {
            this.bytesTransferred = x.bytesTransferred
            this.objectsTransferred = x.objectsTransferred
            this.totalBytes = x.totalBytes
            this.totalObjects = x.totalObjects
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.DataTransfer = DataTransfer(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
