// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model



public class CreateJobRequest private constructor(builder: Builder) {
    /**
     * The ID for the address that you want the Snow device shipped to.
     */
    public val addressId: kotlin.String? = builder.addressId
    /**
     * The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this `clusterId` value. The other job attributes are inherited from the cluster.
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * Defines an optional description of this specific job, for example `Important Photos 2016-08-11`.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Defines the device configuration for an Snowcone job.
     *
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
     */
    public val deviceConfiguration: aws.sdk.kotlin.services.snowball.model.DeviceConfiguration? = builder.deviceConfiguration
    /**
     * The forwarding address ID for a job. This field is not supported in most Regions.
     */
    public val forwardingAddressId: kotlin.String? = builder.forwardingAddressId
    /**
     * The highest impact level of data that will be stored or processed on the device, provided at job creation.
     */
    public val impactLevel: aws.sdk.kotlin.services.snowball.model.ImpactLevel? = builder.impactLevel
    /**
     * Defines the type of job that you're creating.
     */
    public val jobType: aws.sdk.kotlin.services.snowball.model.JobType? = builder.jobType
    /**
     * The `KmsKeyARN` that you want to associate with this job. `KmsKeyARN`s are created using the [CreateKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html) Key Management Service (KMS) API action.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The ID of the long-term pricing type for the device.
     */
    public val longTermPricingId: kotlin.String? = builder.longTermPricingId
    /**
     * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
     */
    public val notification: aws.sdk.kotlin.services.snowball.model.Notification? = builder.notification
    /**
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.
     */
    public val onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = builder.onDeviceServiceConfiguration
    /**
     * Information identifying the person picking up the device.
     */
    public val pickupDetails: aws.sdk.kotlin.services.snowball.model.PickupDetails? = builder.pickupDetails
    /**
     * Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to `INSTALLED_AUTOSTART`, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Edge client to manage the device. When set to `NOT_INSTALLED`, remote management will not be available on the device.
     */
    public val remoteManagement: aws.sdk.kotlin.services.snowball.model.RemoteManagement? = builder.remoteManagement
    /**
     * Defines the Amazon S3 buckets associated with this job.
     *
     * With `IMPORT` jobs, you specify the bucket or buckets that your transferred data will be imported into.
     *
     * With `EXPORT` jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a `KeyRange` value. If you choose to export a range, you define the length of the range by providing either an inclusive `BeginMarker` value, an inclusive `EndMarker` value, or both. Ranges are UTF-8 binary sorted.
     */
    public val resources: aws.sdk.kotlin.services.snowball.model.JobResource? = builder.resources
    /**
     * The `RoleARN` that you want to associate with this job. `RoleArn`s are created using the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) Identity and Access Management (IAM) API action.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:
     * + In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.
     * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
     * + In India, Snow devices are delivered in one to seven days.
     * + In the US, you have access to one-day shipping and two-day shipping.
     */
    public val shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = builder.shippingOption
    /**
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     *
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
     */
    public val snowballCapacityPreference: aws.sdk.kotlin.services.snowball.model.SnowballCapacity? = builder.snowballCapacityPreference
    /**
     * The type of Snow Family devices to use for this job.
     *
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the `EDGE` device type.
     *
     * The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is `EDGE`.
     *
     * For more information, see [Snowball Edge Device Options](https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html) in the Snowball Edge Developer Guide.
     *
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
     */
    public val snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = builder.snowballType
    /**
     * The tax documents required in your Amazon Web Services Region.
     */
    public val taxDocuments: aws.sdk.kotlin.services.snowball.model.TaxDocuments? = builder.taxDocuments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.CreateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobRequest(")
        append("addressId=$addressId,")
        append("clusterId=$clusterId,")
        append("description=$description,")
        append("deviceConfiguration=$deviceConfiguration,")
        append("forwardingAddressId=$forwardingAddressId,")
        append("impactLevel=$impactLevel,")
        append("jobType=$jobType,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("longTermPricingId=$longTermPricingId,")
        append("notification=$notification,")
        append("onDeviceServiceConfiguration=$onDeviceServiceConfiguration,")
        append("pickupDetails=$pickupDetails,")
        append("remoteManagement=$remoteManagement,")
        append("resources=$resources,")
        append("roleArn=$roleArn,")
        append("shippingOption=$shippingOption,")
        append("snowballCapacityPreference=$snowballCapacityPreference,")
        append("snowballType=$snowballType,")
        append("taxDocuments=$taxDocuments")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressId?.hashCode() ?: 0
        result = 31 * result + (clusterId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (forwardingAddressId?.hashCode() ?: 0)
        result = 31 * result + (impactLevel?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (longTermPricingId?.hashCode() ?: 0)
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (onDeviceServiceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pickupDetails?.hashCode() ?: 0)
        result = 31 * result + (remoteManagement?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (shippingOption?.hashCode() ?: 0)
        result = 31 * result + (snowballCapacityPreference?.hashCode() ?: 0)
        result = 31 * result + (snowballType?.hashCode() ?: 0)
        result = 31 * result + (taxDocuments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobRequest

        if (addressId != other.addressId) return false
        if (clusterId != other.clusterId) return false
        if (description != other.description) return false
        if (deviceConfiguration != other.deviceConfiguration) return false
        if (forwardingAddressId != other.forwardingAddressId) return false
        if (impactLevel != other.impactLevel) return false
        if (jobType != other.jobType) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (longTermPricingId != other.longTermPricingId) return false
        if (notification != other.notification) return false
        if (onDeviceServiceConfiguration != other.onDeviceServiceConfiguration) return false
        if (pickupDetails != other.pickupDetails) return false
        if (remoteManagement != other.remoteManagement) return false
        if (resources != other.resources) return false
        if (roleArn != other.roleArn) return false
        if (shippingOption != other.shippingOption) return false
        if (snowballCapacityPreference != other.snowballCapacityPreference) return false
        if (snowballType != other.snowballType) return false
        if (taxDocuments != other.taxDocuments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.CreateJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the address that you want the Snow device shipped to.
         */
        public var addressId: kotlin.String? = null
        /**
         * The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this `clusterId` value. The other job attributes are inherited from the cluster.
         */
        public var clusterId: kotlin.String? = null
        /**
         * Defines an optional description of this specific job, for example `Important Photos 2016-08-11`.
         */
        public var description: kotlin.String? = null
        /**
         * Defines the device configuration for an Snowcone job.
         *
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
         */
        public var deviceConfiguration: aws.sdk.kotlin.services.snowball.model.DeviceConfiguration? = null
        /**
         * The forwarding address ID for a job. This field is not supported in most Regions.
         */
        public var forwardingAddressId: kotlin.String? = null
        /**
         * The highest impact level of data that will be stored or processed on the device, provided at job creation.
         */
        public var impactLevel: aws.sdk.kotlin.services.snowball.model.ImpactLevel? = null
        /**
         * Defines the type of job that you're creating.
         */
        public var jobType: aws.sdk.kotlin.services.snowball.model.JobType? = null
        /**
         * The `KmsKeyARN` that you want to associate with this job. `KmsKeyARN`s are created using the [CreateKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html) Key Management Service (KMS) API action.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The ID of the long-term pricing type for the device.
         */
        public var longTermPricingId: kotlin.String? = null
        /**
         * Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.
         */
        public var notification: aws.sdk.kotlin.services.snowball.model.Notification? = null
        /**
         * Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.
         */
        public var onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = null
        /**
         * Information identifying the person picking up the device.
         */
        public var pickupDetails: aws.sdk.kotlin.services.snowball.model.PickupDetails? = null
        /**
         * Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to `INSTALLED_AUTOSTART`, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Edge client to manage the device. When set to `NOT_INSTALLED`, remote management will not be available on the device.
         */
        public var remoteManagement: aws.sdk.kotlin.services.snowball.model.RemoteManagement? = null
        /**
         * Defines the Amazon S3 buckets associated with this job.
         *
         * With `IMPORT` jobs, you specify the bucket or buckets that your transferred data will be imported into.
         *
         * With `EXPORT` jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a `KeyRange` value. If you choose to export a range, you define the length of the range by providing either an inclusive `BeginMarker` value, an inclusive `EndMarker` value, or both. Ranges are UTF-8 binary sorted.
         */
        public var resources: aws.sdk.kotlin.services.snowball.model.JobResource? = null
        /**
         * The `RoleARN` that you want to associate with this job. `RoleArn`s are created using the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) Identity and Access Management (IAM) API action.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:
         * + In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.
         * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
         * + In India, Snow devices are delivered in one to seven days.
         * + In the US, you have access to one-day shipping and two-day shipping.
         */
        public var shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = null
        /**
         * If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         *
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
         */
        public var snowballCapacityPreference: aws.sdk.kotlin.services.snowball.model.SnowballCapacity? = null
        /**
         * The type of Snow Family devices to use for this job.
         *
         * For cluster jobs, Amazon Web Services Snow Family currently supports only the `EDGE` device type.
         *
         * The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is `EDGE`.
         *
         * For more information, see [Snowball Edge Device Options](https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html) in the Snowball Edge Developer Guide.
         *
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
         */
        public var snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = null
        /**
         * The tax documents required in your Amazon Web Services Region.
         */
        public var taxDocuments: aws.sdk.kotlin.services.snowball.model.TaxDocuments? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.CreateJobRequest) : this() {
            this.addressId = x.addressId
            this.clusterId = x.clusterId
            this.description = x.description
            this.deviceConfiguration = x.deviceConfiguration
            this.forwardingAddressId = x.forwardingAddressId
            this.impactLevel = x.impactLevel
            this.jobType = x.jobType
            this.kmsKeyArn = x.kmsKeyArn
            this.longTermPricingId = x.longTermPricingId
            this.notification = x.notification
            this.onDeviceServiceConfiguration = x.onDeviceServiceConfiguration
            this.pickupDetails = x.pickupDetails
            this.remoteManagement = x.remoteManagement
            this.resources = x.resources
            this.roleArn = x.roleArn
            this.shippingOption = x.shippingOption
            this.snowballCapacityPreference = x.snowballCapacityPreference
            this.snowballType = x.snowballType
            this.taxDocuments = x.taxDocuments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.CreateJobRequest = CreateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.DeviceConfiguration] inside the given [block]
         */
        public fun deviceConfiguration(block: aws.sdk.kotlin.services.snowball.model.DeviceConfiguration.Builder.() -> kotlin.Unit) {
            this.deviceConfiguration = aws.sdk.kotlin.services.snowball.model.DeviceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.Notification] inside the given [block]
         */
        public fun notification(block: aws.sdk.kotlin.services.snowball.model.Notification.Builder.() -> kotlin.Unit) {
            this.notification = aws.sdk.kotlin.services.snowball.model.Notification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration] inside the given [block]
         */
        public fun onDeviceServiceConfiguration(block: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.Builder.() -> kotlin.Unit) {
            this.onDeviceServiceConfiguration = aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.PickupDetails] inside the given [block]
         */
        public fun pickupDetails(block: aws.sdk.kotlin.services.snowball.model.PickupDetails.Builder.() -> kotlin.Unit) {
            this.pickupDetails = aws.sdk.kotlin.services.snowball.model.PickupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.JobResource] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.snowball.model.JobResource.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.snowball.model.JobResource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.TaxDocuments] inside the given [block]
         */
        public fun taxDocuments(block: aws.sdk.kotlin.services.snowball.model.TaxDocuments.Builder.() -> kotlin.Unit) {
            this.taxDocuments = aws.sdk.kotlin.services.snowball.model.TaxDocuments.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
