// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model



public class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * The ID for the address that you want the cluster shipped to.
     */
    public val addressId: kotlin.String? = builder.addressId
    /**
     * An optional description of this specific cluster, for example `Environmental Data Cluster-01`.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less (underprovisioned) than what needed to meet capacity requirement specified with `OnDeviceServiceConfiguration`.
     */
    public val forceCreateJobs: kotlin.Boolean? = builder.forceCreateJobs
    /**
     * The forwarding address ID for a cluster. This field is not supported in most regions.
     */
    public val forwardingAddressId: kotlin.String? = builder.forwardingAddressId
    /**
     * If provided, each job will be automatically created and associated with the new cluster. If not provided, will be treated as 0.
     */
    public val initialClusterSize: kotlin.Int? = builder.initialClusterSize
    /**
     * The type of job for this cluster. Currently, the only job type supported for clusters is `LOCAL_USE`.
     *
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
     */
    public val jobType: aws.sdk.kotlin.services.snowball.model.JobType? = builder.jobType
    /**
     * The `KmsKeyARN` value that you want to associate with this cluster. `KmsKeyARN` values are created by using the [CreateKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html) API action in Key Management Service (KMS).
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * Lists long-term pricing id that will be used to associate with jobs automatically created for the new cluster.
     */
    public val longTermPricingIds: List<String>? = builder.longTermPricingIds
    /**
     * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     */
    public val notification: aws.sdk.kotlin.services.snowball.model.Notification? = builder.notification
    /**
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).
     */
    public val onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = builder.onDeviceServiceConfiguration
    /**
     * Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to `INSTALLED_AUTOSTART`, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     */
    public val remoteManagement: aws.sdk.kotlin.services.snowball.model.RemoteManagement? = builder.remoteManagement
    /**
     * The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language.
     */
    public val resources: aws.sdk.kotlin.services.snowball.model.JobResource? = builder.resources
    /**
     * The `RoleARN` that you want to associate with this cluster. `RoleArn` values are created by using the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) API action in Identity and Access Management (IAM).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:
     * + In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.
     * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
     * + In India, Snow devices are delivered in one to seven days.
     * + In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *
     * + In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.
     * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
     * + In India, Snow devices are delivered in one to seven days.
     * + In the US, you have access to one-day shipping and two-day shipping.
     */
    public val shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = builder.shippingOption
    /**
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     *
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
     */
    public val snowballCapacityPreference: aws.sdk.kotlin.services.snowball.model.SnowballCapacity? = builder.snowballCapacityPreference
    /**
     * The type of Snow Family devices to use for this cluster.
     *
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the `EDGE` device type.
     *
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
     */
    public val snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = builder.snowballType
    /**
     * The tax documents required in your Amazon Web Services Region.
     */
    public val taxDocuments: aws.sdk.kotlin.services.snowball.model.TaxDocuments? = builder.taxDocuments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("addressId=$addressId,")
        append("description=$description,")
        append("forceCreateJobs=$forceCreateJobs,")
        append("forwardingAddressId=$forwardingAddressId,")
        append("initialClusterSize=$initialClusterSize,")
        append("jobType=$jobType,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("longTermPricingIds=$longTermPricingIds,")
        append("notification=$notification,")
        append("onDeviceServiceConfiguration=$onDeviceServiceConfiguration,")
        append("remoteManagement=$remoteManagement,")
        append("resources=$resources,")
        append("roleArn=$roleArn,")
        append("shippingOption=$shippingOption,")
        append("snowballCapacityPreference=$snowballCapacityPreference,")
        append("snowballType=$snowballType,")
        append("taxDocuments=$taxDocuments")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (forceCreateJobs?.hashCode() ?: 0)
        result = 31 * result + (forwardingAddressId?.hashCode() ?: 0)
        result = 31 * result + (initialClusterSize ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (longTermPricingIds?.hashCode() ?: 0)
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (onDeviceServiceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (remoteManagement?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (shippingOption?.hashCode() ?: 0)
        result = 31 * result + (snowballCapacityPreference?.hashCode() ?: 0)
        result = 31 * result + (snowballType?.hashCode() ?: 0)
        result = 31 * result + (taxDocuments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (addressId != other.addressId) return false
        if (description != other.description) return false
        if (forceCreateJobs != other.forceCreateJobs) return false
        if (forwardingAddressId != other.forwardingAddressId) return false
        if (initialClusterSize != other.initialClusterSize) return false
        if (jobType != other.jobType) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (longTermPricingIds != other.longTermPricingIds) return false
        if (notification != other.notification) return false
        if (onDeviceServiceConfiguration != other.onDeviceServiceConfiguration) return false
        if (remoteManagement != other.remoteManagement) return false
        if (resources != other.resources) return false
        if (roleArn != other.roleArn) return false
        if (shippingOption != other.shippingOption) return false
        if (snowballCapacityPreference != other.snowballCapacityPreference) return false
        if (snowballType != other.snowballType) return false
        if (taxDocuments != other.taxDocuments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.CreateClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the address that you want the cluster shipped to.
         */
        public var addressId: kotlin.String? = null
        /**
         * An optional description of this specific cluster, for example `Environmental Data Cluster-01`.
         */
        public var description: kotlin.String? = null
        /**
         * Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less (underprovisioned) than what needed to meet capacity requirement specified with `OnDeviceServiceConfiguration`.
         */
        public var forceCreateJobs: kotlin.Boolean? = null
        /**
         * The forwarding address ID for a cluster. This field is not supported in most regions.
         */
        public var forwardingAddressId: kotlin.String? = null
        /**
         * If provided, each job will be automatically created and associated with the new cluster. If not provided, will be treated as 0.
         */
        public var initialClusterSize: kotlin.Int? = null
        /**
         * The type of job for this cluster. Currently, the only job type supported for clusters is `LOCAL_USE`.
         *
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
         */
        public var jobType: aws.sdk.kotlin.services.snowball.model.JobType? = null
        /**
         * The `KmsKeyARN` value that you want to associate with this cluster. `KmsKeyARN` values are created by using the [CreateKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html) API action in Key Management Service (KMS).
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * Lists long-term pricing id that will be used to associate with jobs automatically created for the new cluster.
         */
        public var longTermPricingIds: List<String>? = null
        /**
         * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
         */
        public var notification: aws.sdk.kotlin.services.snowball.model.Notification? = null
        /**
         * Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).
         */
        public var onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = null
        /**
         * Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to `INSTALLED_AUTOSTART`, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
         */
        public var remoteManagement: aws.sdk.kotlin.services.snowball.model.RemoteManagement? = null
        /**
         * The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language.
         */
        public var resources: aws.sdk.kotlin.services.snowball.model.JobResource? = null
        /**
         * The `RoleARN` that you want to associate with this cluster. `RoleArn` values are created by using the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) API action in Identity and Access Management (IAM).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:
         * + In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.
         * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
         * + In India, Snow devices are delivered in one to seven days.
         * + In the United States of America (US), you have access to one-day shipping and two-day shipping.
         *
         * + In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.
         * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
         * + In India, Snow devices are delivered in one to seven days.
         * + In the US, you have access to one-day shipping and two-day shipping.
         */
        public var shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = null
        /**
         * If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
         *
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
         */
        public var snowballCapacityPreference: aws.sdk.kotlin.services.snowball.model.SnowballCapacity? = null
        /**
         * The type of Snow Family devices to use for this cluster.
         *
         * For cluster jobs, Amazon Web Services Snow Family currently supports only the `EDGE` device type.
         *
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
         */
        public var snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = null
        /**
         * The tax documents required in your Amazon Web Services Region.
         */
        public var taxDocuments: aws.sdk.kotlin.services.snowball.model.TaxDocuments? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.CreateClusterRequest) : this() {
            this.addressId = x.addressId
            this.description = x.description
            this.forceCreateJobs = x.forceCreateJobs
            this.forwardingAddressId = x.forwardingAddressId
            this.initialClusterSize = x.initialClusterSize
            this.jobType = x.jobType
            this.kmsKeyArn = x.kmsKeyArn
            this.longTermPricingIds = x.longTermPricingIds
            this.notification = x.notification
            this.onDeviceServiceConfiguration = x.onDeviceServiceConfiguration
            this.remoteManagement = x.remoteManagement
            this.resources = x.resources
            this.roleArn = x.roleArn
            this.shippingOption = x.shippingOption
            this.snowballCapacityPreference = x.snowballCapacityPreference
            this.snowballType = x.snowballType
            this.taxDocuments = x.taxDocuments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.CreateClusterRequest = CreateClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.Notification] inside the given [block]
         */
        public fun notification(block: aws.sdk.kotlin.services.snowball.model.Notification.Builder.() -> kotlin.Unit) {
            this.notification = aws.sdk.kotlin.services.snowball.model.Notification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration] inside the given [block]
         */
        public fun onDeviceServiceConfiguration(block: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.Builder.() -> kotlin.Unit) {
            this.onDeviceServiceConfiguration = aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.JobResource] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.snowball.model.JobResource.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.snowball.model.JobResource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.TaxDocuments] inside the given [block]
         */
        public fun taxDocuments(block: aws.sdk.kotlin.services.snowball.model.TaxDocuments.Builder.() -> kotlin.Unit) {
            this.taxDocuments = aws.sdk.kotlin.services.snowball.model.TaxDocuments.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
