// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model



/**
 * The address that you want the Snow device(s) associated with a specific job to be shipped to. Addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. Although no individual elements of the `Address` are required, if the address is invalid or unsupported, then an exception is thrown.
 */
public class Address private constructor(builder: Builder) {
    /**
     * The unique ID for an address.
     */
    public val addressId: kotlin.String? = builder.addressId
    /**
     * The city in an address that a Snow device is to be delivered to.
     */
    public val city: kotlin.String? = builder.city
    /**
     * The name of the company to receive a Snow device at an address.
     */
    public val company: kotlin.String? = builder.company
    /**
     * The country in an address that a Snow device is to be delivered to.
     */
    public val country: kotlin.String? = builder.country
    /**
     * If the address you are creating is a primary address, then set this option to true. This field is not supported in most regions.
     */
    public val isRestricted: kotlin.Boolean = builder.isRestricted
    /**
     * This field is no longer used and the value is ignored.
     */
    public val landmark: kotlin.String? = builder.landmark
    /**
     * The name of a person to receive a Snow device at an address.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The phone number associated with an address that a Snow device is to be delivered to.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The postal code in an address that a Snow device is to be delivered to.
     */
    public val postalCode: kotlin.String? = builder.postalCode
    /**
     * This field is no longer used and the value is ignored.
     */
    public val prefectureOrDistrict: kotlin.String? = builder.prefectureOrDistrict
    /**
     * The state or province in an address that a Snow device is to be delivered to.
     */
    public val stateOrProvince: kotlin.String? = builder.stateOrProvince
    /**
     * The first line in a street address that a Snow device is to be delivered to.
     */
    public val street1: kotlin.String? = builder.street1
    /**
     * The second line in a street address that a Snow device is to be delivered to.
     */
    public val street2: kotlin.String? = builder.street2
    /**
     * The third line in a street address that a Snow device is to be delivered to.
     */
    public val street3: kotlin.String? = builder.street3
    /**
     * Differentiates between delivery address and pickup address in the customer account. Provided at job creation.
     */
    public val type: aws.sdk.kotlin.services.snowball.model.AddressType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.Address = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Address(")
        append("addressId=$addressId,")
        append("city=$city,")
        append("company=$company,")
        append("country=$country,")
        append("isRestricted=$isRestricted,")
        append("landmark=$landmark,")
        append("name=$name,")
        append("phoneNumber=$phoneNumber,")
        append("postalCode=$postalCode,")
        append("prefectureOrDistrict=$prefectureOrDistrict,")
        append("stateOrProvince=$stateOrProvince,")
        append("street1=$street1,")
        append("street2=$street2,")
        append("street3=$street3,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressId?.hashCode() ?: 0
        result = 31 * result + (city?.hashCode() ?: 0)
        result = 31 * result + (company?.hashCode() ?: 0)
        result = 31 * result + (country?.hashCode() ?: 0)
        result = 31 * result + (isRestricted.hashCode())
        result = 31 * result + (landmark?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (postalCode?.hashCode() ?: 0)
        result = 31 * result + (prefectureOrDistrict?.hashCode() ?: 0)
        result = 31 * result + (stateOrProvince?.hashCode() ?: 0)
        result = 31 * result + (street1?.hashCode() ?: 0)
        result = 31 * result + (street2?.hashCode() ?: 0)
        result = 31 * result + (street3?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Address

        if (addressId != other.addressId) return false
        if (city != other.city) return false
        if (company != other.company) return false
        if (country != other.country) return false
        if (isRestricted != other.isRestricted) return false
        if (landmark != other.landmark) return false
        if (name != other.name) return false
        if (phoneNumber != other.phoneNumber) return false
        if (postalCode != other.postalCode) return false
        if (prefectureOrDistrict != other.prefectureOrDistrict) return false
        if (stateOrProvince != other.stateOrProvince) return false
        if (street1 != other.street1) return false
        if (street2 != other.street2) return false
        if (street3 != other.street3) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.Address = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID for an address.
         */
        public var addressId: kotlin.String? = null
        /**
         * The city in an address that a Snow device is to be delivered to.
         */
        public var city: kotlin.String? = null
        /**
         * The name of the company to receive a Snow device at an address.
         */
        public var company: kotlin.String? = null
        /**
         * The country in an address that a Snow device is to be delivered to.
         */
        public var country: kotlin.String? = null
        /**
         * If the address you are creating is a primary address, then set this option to true. This field is not supported in most regions.
         */
        public var isRestricted: kotlin.Boolean = false
        /**
         * This field is no longer used and the value is ignored.
         */
        public var landmark: kotlin.String? = null
        /**
         * The name of a person to receive a Snow device at an address.
         */
        public var name: kotlin.String? = null
        /**
         * The phone number associated with an address that a Snow device is to be delivered to.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * The postal code in an address that a Snow device is to be delivered to.
         */
        public var postalCode: kotlin.String? = null
        /**
         * This field is no longer used and the value is ignored.
         */
        public var prefectureOrDistrict: kotlin.String? = null
        /**
         * The state or province in an address that a Snow device is to be delivered to.
         */
        public var stateOrProvince: kotlin.String? = null
        /**
         * The first line in a street address that a Snow device is to be delivered to.
         */
        public var street1: kotlin.String? = null
        /**
         * The second line in a street address that a Snow device is to be delivered to.
         */
        public var street2: kotlin.String? = null
        /**
         * The third line in a street address that a Snow device is to be delivered to.
         */
        public var street3: kotlin.String? = null
        /**
         * Differentiates between delivery address and pickup address in the customer account. Provided at job creation.
         */
        public var type: aws.sdk.kotlin.services.snowball.model.AddressType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.Address) : this() {
            this.addressId = x.addressId
            this.city = x.city
            this.company = x.company
            this.country = x.country
            this.isRestricted = x.isRestricted
            this.landmark = x.landmark
            this.name = x.name
            this.phoneNumber = x.phoneNumber
            this.postalCode = x.postalCode
            this.prefectureOrDistrict = x.prefectureOrDistrict
            this.stateOrProvince = x.stateOrProvince
            this.street1 = x.street1
            this.street2 = x.street2
            this.street3 = x.street3
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.Address = Address(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
