// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.serde

import aws.sdk.kotlin.services.sms.model.GetServersResponse
import aws.sdk.kotlin.services.sms.model.Server
import aws.sdk.kotlin.services.sms.model.ServerCatalogStatus
import aws.sdk.kotlin.services.sms.model.SmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetServersOperationDeserializer: HttpDeserialize<GetServersResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetServersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetServersError(context, call)
        }
        val builder = GetServersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetServersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetServersError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalError" -> InternalErrorDeserializer().deserialize(context, wrappedCall)
        "MissingRequiredParameterException" -> MissingRequiredParameterExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetServersOperationBody(builder: GetServersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTMODIFIEDON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedOn"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SERVERCATALOGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("serverCatalogStatus"))
    val SERVERLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("serverList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTMODIFIEDON_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SERVERCATALOGSTATUS_DESCRIPTOR)
        field(SERVERLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTMODIFIEDON_DESCRIPTOR.index -> builder.lastModifiedOn = deserializeString().let { Instant.fromEpochSeconds(it) }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SERVERCATALOGSTATUS_DESCRIPTOR.index -> builder.serverCatalogStatus = deserializeString().let { ServerCatalogStatus.fromValue(it) }
                SERVERLIST_DESCRIPTOR.index -> builder.serverList =
                    deserializer.deserializeList(SERVERLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Server>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
