// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.serde

import aws.sdk.kotlin.services.sms.model.AppValidationConfiguration
import aws.sdk.kotlin.services.sms.model.GetAppValidationConfigurationResponse
import aws.sdk.kotlin.services.sms.model.ServerGroupValidationConfiguration
import aws.sdk.kotlin.services.sms.model.SmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetAppValidationConfigurationOperationDeserializer: HttpDeserialize<GetAppValidationConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetAppValidationConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAppValidationConfigurationError(context, call)
        }
        val builder = GetAppValidationConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAppValidationConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetAppValidationConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalError" -> InternalErrorDeserializer().deserialize(context, wrappedCall)
        "MissingRequiredParameterException" -> MissingRequiredParameterExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAppValidationConfigurationOperationBody(builder: GetAppValidationConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPVALIDATIONCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("appValidationConfigurations"))
    val SERVERGROUPVALIDATIONCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("serverGroupValidationConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPVALIDATIONCONFIGURATIONS_DESCRIPTOR)
        field(SERVERGROUPVALIDATIONCONFIGURATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPVALIDATIONCONFIGURATIONS_DESCRIPTOR.index -> builder.appValidationConfigurations =
                    deserializer.deserializeList(APPVALIDATIONCONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<AppValidationConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAppValidationConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SERVERGROUPVALIDATIONCONFIGURATIONS_DESCRIPTOR.index -> builder.serverGroupValidationConfigurations =
                    deserializer.deserializeList(SERVERGROUPVALIDATIONCONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ServerGroupValidationConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServerGroupValidationConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
