// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.serde

import aws.sdk.kotlin.services.sms.model.CreateReplicationJobResponse
import aws.sdk.kotlin.services.sms.model.SmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateReplicationJobOperationDeserializer: HttpDeserialize<CreateReplicationJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateReplicationJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateReplicationJobError(context, call)
        }
        val builder = CreateReplicationJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateReplicationJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateReplicationJobError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReplicationJobAlreadyExistsException" -> ReplicationJobAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "NoConnectorsAvailableException" -> NoConnectorsAvailableExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "TemporarilyUnavailableException" -> TemporarilyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalError" -> InternalErrorDeserializer().deserialize(context, wrappedCall)
        "ServerCannotBeReplicatedException" -> ServerCannotBeReplicatedExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingRequiredParameterException" -> MissingRequiredParameterExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateReplicationJobOperationBody(builder: CreateReplicationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REPLICATIONJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("replicationJobId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REPLICATIONJOBID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPLICATIONJOBID_DESCRIPTOR.index -> builder.replicationJobId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
