// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.serde

import aws.sdk.kotlin.services.sms.model.AppSummary
import aws.sdk.kotlin.services.sms.model.CreateAppResponse
import aws.sdk.kotlin.services.sms.model.ServerGroup
import aws.sdk.kotlin.services.sms.model.SmsException
import aws.sdk.kotlin.services.sms.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateAppOperationDeserializer: HttpDeserialize<CreateAppResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateAppResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAppError(context, call)
        }
        val builder = CreateAppResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAppOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateAppError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedOperationException" -> UnauthorizedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalError" -> InternalErrorDeserializer().deserialize(context, wrappedCall)
        "MissingRequiredParameterException" -> MissingRequiredParameterExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAppOperationBody(builder: CreateAppResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("appSummary"))
    val SERVERGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("serverGroups"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPSUMMARY_DESCRIPTOR)
        field(SERVERGROUPS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPSUMMARY_DESCRIPTOR.index -> builder.appSummary = deserializeAppSummaryDocument(deserializer)
                SERVERGROUPS_DESCRIPTOR.index -> builder.serverGroups =
                    deserializer.deserializeList(SERVERGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<ServerGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServerGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
