// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.paginators

import aws.sdk.kotlin.services.sms.SmsClient
import aws.sdk.kotlin.services.sms.model.Connector
import aws.sdk.kotlin.services.sms.model.GetConnectorsRequest
import aws.sdk.kotlin.services.sms.model.GetConnectorsResponse
import aws.sdk.kotlin.services.sms.model.GetReplicationJobsRequest
import aws.sdk.kotlin.services.sms.model.GetReplicationJobsResponse
import aws.sdk.kotlin.services.sms.model.GetReplicationRunsRequest
import aws.sdk.kotlin.services.sms.model.GetReplicationRunsResponse
import aws.sdk.kotlin.services.sms.model.GetServersRequest
import aws.sdk.kotlin.services.sms.model.GetServersResponse
import aws.sdk.kotlin.services.sms.model.ReplicationJob
import aws.sdk.kotlin.services.sms.model.ReplicationRun
import aws.sdk.kotlin.services.sms.model.Server
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetConnectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetConnectorsResponse]
 */
public fun SmsClient.getConnectorsPaginated(initialRequest: GetConnectorsRequest = GetConnectorsRequest { }): Flow<GetConnectorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getConnectorsPaginated.getConnectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetConnectorsResponse]
 */
public fun SmsClient.getConnectorsPaginated(block: GetConnectorsRequest.Builder.() -> Unit): Flow<GetConnectorsResponse> =
    getConnectorsPaginated(GetConnectorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getConnectorsPaginated]
 * to access the nested member [Connector]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Connector]
 */
@JvmName("getConnectorsResponseConnector")
public fun Flow<GetConnectorsResponse>.connectorList(): Flow<Connector> =
    transform() { response ->
        response.connectorList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetReplicationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetReplicationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReplicationJobsResponse]
 */
public fun SmsClient.getReplicationJobsPaginated(initialRequest: GetReplicationJobsRequest = GetReplicationJobsRequest { }): Flow<GetReplicationJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getReplicationJobsPaginated.getReplicationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetReplicationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReplicationJobsResponse]
 */
public fun SmsClient.getReplicationJobsPaginated(block: GetReplicationJobsRequest.Builder.() -> Unit): Flow<GetReplicationJobsResponse> =
    getReplicationJobsPaginated(GetReplicationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getReplicationJobsPaginated]
 * to access the nested member [ReplicationJob]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReplicationJob]
 */
@JvmName("getReplicationJobsResponseReplicationJob")
public fun Flow<GetReplicationJobsResponse>.replicationJobList(): Flow<ReplicationJob> =
    transform() { response ->
        response.replicationJobList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetReplicationRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetReplicationRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReplicationRunsResponse]
 */
public fun SmsClient.getReplicationRunsPaginated(initialRequest: GetReplicationRunsRequest): Flow<GetReplicationRunsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getReplicationRunsPaginated.getReplicationRuns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetReplicationRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetReplicationRunsResponse]
 */
public fun SmsClient.getReplicationRunsPaginated(block: GetReplicationRunsRequest.Builder.() -> Unit): Flow<GetReplicationRunsResponse> =
    getReplicationRunsPaginated(GetReplicationRunsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getReplicationRunsPaginated]
 * to access the nested member [ReplicationRun]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReplicationRun]
 */
@JvmName("getReplicationRunsResponseReplicationRun")
public fun Flow<GetReplicationRunsResponse>.replicationRunList(): Flow<ReplicationRun> =
    transform() { response ->
        response.replicationRunList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetServersResponse]
 */
public fun SmsClient.getServersPaginated(initialRequest: GetServersRequest = GetServersRequest { }): Flow<GetServersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getServersPaginated.getServers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetServersResponse]
 */
public fun SmsClient.getServersPaginated(block: GetServersRequest.Builder.() -> Unit): Flow<GetServersResponse> =
    getServersPaginated(GetServersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getServersPaginated]
 * to access the nested member [Server]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Server]
 */
@JvmName("getServersResponseServer")
public fun Flow<GetServersResponse>.serverList(): Flow<Server> =
    transform() { response ->
        response.serverList?.forEach {
            emit(it)
        }
    }
