// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.model

import aws.smithy.kotlin.runtime.time.Instant

public class UpdateReplicationJobRequest private constructor(builder: Builder) {
    /**
     * The description of the replication job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * When true, the replication job produces encrypted AMIs. For more information, `KmsKeyId`.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The time between consecutive replication runs, in hours.
     */
    public val frequency: kotlin.Int? = builder.frequency
    /**
     * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
     * + KMS key ID
     * + KMS key alias
     * + ARN referring to the KMS key ID
     * + ARN referring to the KMS key alias
     *
     * If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The license type to be used for the AMI created by a successful replication run.
     */
    public val licenseType: aws.sdk.kotlin.services.sms.model.LicenseType? = builder.licenseType
    /**
     * The start time of the next replication run.
     */
    public val nextReplicationRunStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.nextReplicationRunStartTime
    /**
     * The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.
     */
    public val numberOfRecentAmisToKeep: kotlin.Int? = builder.numberOfRecentAmisToKeep
    /**
     * The ID of the replication job.
     */
    public val replicationJobId: kotlin.String? = builder.replicationJobId
    /**
     * The name of the IAM role to be used by Server Migration Service.
     */
    public val roleName: kotlin.String? = builder.roleName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sms.model.UpdateReplicationJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateReplicationJobRequest(")
        append("description=$description,")
        append("encrypted=$encrypted,")
        append("frequency=$frequency,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseType=$licenseType,")
        append("nextReplicationRunStartTime=$nextReplicationRunStartTime,")
        append("numberOfRecentAmisToKeep=$numberOfRecentAmisToKeep,")
        append("replicationJobId=$replicationJobId,")
        append("roleName=$roleName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (frequency ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (nextReplicationRunStartTime?.hashCode() ?: 0)
        result = 31 * result + (numberOfRecentAmisToKeep ?: 0)
        result = 31 * result + (replicationJobId?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateReplicationJobRequest

        if (description != other.description) return false
        if (encrypted != other.encrypted) return false
        if (frequency != other.frequency) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseType != other.licenseType) return false
        if (nextReplicationRunStartTime != other.nextReplicationRunStartTime) return false
        if (numberOfRecentAmisToKeep != other.numberOfRecentAmisToKeep) return false
        if (replicationJobId != other.replicationJobId) return false
        if (roleName != other.roleName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sms.model.UpdateReplicationJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the replication job.
         */
        public var description: kotlin.String? = null
        /**
         * When true, the replication job produces encrypted AMIs. For more information, `KmsKeyId`.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The time between consecutive replication runs, in hours.
         */
        public var frequency: kotlin.Int? = null
        /**
         * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
         * + KMS key ID
         * + KMS key alias
         * + ARN referring to the KMS key ID
         * + ARN referring to the KMS key alias
         *
         * If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The license type to be used for the AMI created by a successful replication run.
         */
        public var licenseType: aws.sdk.kotlin.services.sms.model.LicenseType? = null
        /**
         * The start time of the next replication run.
         */
        public var nextReplicationRunStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of SMS-created AMIs to retain. The oldest is deleted after the maximum number is reached and a new AMI is created.
         */
        public var numberOfRecentAmisToKeep: kotlin.Int? = null
        /**
         * The ID of the replication job.
         */
        public var replicationJobId: kotlin.String? = null
        /**
         * The name of the IAM role to be used by Server Migration Service.
         */
        public var roleName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sms.model.UpdateReplicationJobRequest) : this() {
            this.description = x.description
            this.encrypted = x.encrypted
            this.frequency = x.frequency
            this.kmsKeyId = x.kmsKeyId
            this.licenseType = x.licenseType
            this.nextReplicationRunStartTime = x.nextReplicationRunStartTime
            this.numberOfRecentAmisToKeep = x.numberOfRecentAmisToKeep
            this.replicationJobId = x.replicationJobId
            this.roleName = x.roleName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sms.model.UpdateReplicationJobRequest = UpdateReplicationJobRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
