// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The replication parameters for replicating a server.
 */
public class ServerReplicationParameters private constructor(builder: Builder) {
    /**
     * Indicates whether the replication job produces encrypted AMIs.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The frequency of creating replication jobs for the server.
     */
    public val frequency: kotlin.Int? = builder.frequency
    /**
     * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
     * + KMS key ID
     * + KMS key alias
     * + ARN referring to the KMS key ID
     * + ARN referring to the KMS key alias
     *
     * If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The license type for creating a replication job for the server.
     */
    public val licenseType: aws.sdk.kotlin.services.sms.model.LicenseType? = builder.licenseType
    /**
     * The number of recent AMIs to keep when creating a replication job for this server.
     */
    public val numberOfRecentAmisToKeep: kotlin.Int? = builder.numberOfRecentAmisToKeep
    /**
     * Indicates whether to run the replication job one time.
     */
    public val runOnce: kotlin.Boolean? = builder.runOnce
    /**
     * The seed time for creating a replication job for the server.
     */
    public val seedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.seedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sms.model.ServerReplicationParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerReplicationParameters(")
        append("encrypted=$encrypted,")
        append("frequency=$frequency,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseType=$licenseType,")
        append("numberOfRecentAmisToKeep=$numberOfRecentAmisToKeep,")
        append("runOnce=$runOnce,")
        append("seedTime=$seedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encrypted?.hashCode() ?: 0
        result = 31 * result + (frequency ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (numberOfRecentAmisToKeep ?: 0)
        result = 31 * result + (runOnce?.hashCode() ?: 0)
        result = 31 * result + (seedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerReplicationParameters

        if (encrypted != other.encrypted) return false
        if (frequency != other.frequency) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseType != other.licenseType) return false
        if (numberOfRecentAmisToKeep != other.numberOfRecentAmisToKeep) return false
        if (runOnce != other.runOnce) return false
        if (seedTime != other.seedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sms.model.ServerReplicationParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the replication job produces encrypted AMIs.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The frequency of creating replication jobs for the server.
         */
        public var frequency: kotlin.Int? = null
        /**
         * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
         * + KMS key ID
         * + KMS key alias
         * + ARN referring to the KMS key ID
         * + ARN referring to the KMS key alias
         *
         * If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The license type for creating a replication job for the server.
         */
        public var licenseType: aws.sdk.kotlin.services.sms.model.LicenseType? = null
        /**
         * The number of recent AMIs to keep when creating a replication job for this server.
         */
        public var numberOfRecentAmisToKeep: kotlin.Int? = null
        /**
         * Indicates whether to run the replication job one time.
         */
        public var runOnce: kotlin.Boolean? = null
        /**
         * The seed time for creating a replication job for the server.
         */
        public var seedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sms.model.ServerReplicationParameters) : this() {
            this.encrypted = x.encrypted
            this.frequency = x.frequency
            this.kmsKeyId = x.kmsKeyId
            this.licenseType = x.licenseType
            this.numberOfRecentAmisToKeep = x.numberOfRecentAmisToKeep
            this.runOnce = x.runOnce
            this.seedTime = x.seedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sms.model.ServerReplicationParameters = ServerReplicationParameters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
