// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.model



/**
 * Launch configuration for a server.
 */
public class ServerLaunchConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether a publicly accessible IP address is created when launching the server.
     */
    public val associatePublicIpAddress: kotlin.Boolean? = builder.associatePublicIpAddress
    /**
     * Location of an Amazon S3 object.
     */
    public val configureScript: aws.sdk.kotlin.services.sms.model.S3Location? = builder.configureScript
    /**
     * The type of configuration script.
     */
    public val configureScriptType: aws.sdk.kotlin.services.sms.model.ScriptType? = builder.configureScriptType
    /**
     * The name of the Amazon EC2 SSH key to be used for connecting to the launched server.
     */
    public val ec2KeyName: kotlin.String? = builder.ec2KeyName
    /**
     * The name of the IAM instance profile.
     */
    public val iamInstanceProfileName: kotlin.String? = builder.iamInstanceProfileName
    /**
     * The instance type to use when launching the server.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The logical ID of the server in the CloudFormation template.
     */
    public val logicalId: kotlin.String? = builder.logicalId
    /**
     * The ID of the security group that applies to the launched server.
     */
    public val securityGroup: kotlin.String? = builder.securityGroup
    /**
     * The ID of the server with which the launch configuration is associated.
     */
    public val server: aws.sdk.kotlin.services.sms.model.Server? = builder.server
    /**
     * The ID of the subnet the server should be launched into.
     */
    public val subnet: kotlin.String? = builder.subnet
    /**
     * Location of the user-data script to be executed when launching the server.
     */
    public val userData: aws.sdk.kotlin.services.sms.model.UserData? = builder.userData
    /**
     * The ID of the VPC into which the server should be launched.
     */
    public val vpc: kotlin.String? = builder.vpc

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sms.model.ServerLaunchConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerLaunchConfiguration(")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("configureScript=$configureScript,")
        append("configureScriptType=$configureScriptType,")
        append("ec2KeyName=$ec2KeyName,")
        append("iamInstanceProfileName=$iamInstanceProfileName,")
        append("instanceType=$instanceType,")
        append("logicalId=$logicalId,")
        append("securityGroup=$securityGroup,")
        append("server=$server,")
        append("subnet=$subnet,")
        append("userData=$userData,")
        append("vpc=$vpc")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatePublicIpAddress?.hashCode() ?: 0
        result = 31 * result + (configureScript?.hashCode() ?: 0)
        result = 31 * result + (configureScriptType?.hashCode() ?: 0)
        result = 31 * result + (ec2KeyName?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (logicalId?.hashCode() ?: 0)
        result = 31 * result + (securityGroup?.hashCode() ?: 0)
        result = 31 * result + (server?.hashCode() ?: 0)
        result = 31 * result + (subnet?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        result = 31 * result + (vpc?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerLaunchConfiguration

        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (configureScript != other.configureScript) return false
        if (configureScriptType != other.configureScriptType) return false
        if (ec2KeyName != other.ec2KeyName) return false
        if (iamInstanceProfileName != other.iamInstanceProfileName) return false
        if (instanceType != other.instanceType) return false
        if (logicalId != other.logicalId) return false
        if (securityGroup != other.securityGroup) return false
        if (server != other.server) return false
        if (subnet != other.subnet) return false
        if (userData != other.userData) return false
        if (vpc != other.vpc) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sms.model.ServerLaunchConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether a publicly accessible IP address is created when launching the server.
         */
        public var associatePublicIpAddress: kotlin.Boolean? = null
        /**
         * Location of an Amazon S3 object.
         */
        public var configureScript: aws.sdk.kotlin.services.sms.model.S3Location? = null
        /**
         * The type of configuration script.
         */
        public var configureScriptType: aws.sdk.kotlin.services.sms.model.ScriptType? = null
        /**
         * The name of the Amazon EC2 SSH key to be used for connecting to the launched server.
         */
        public var ec2KeyName: kotlin.String? = null
        /**
         * The name of the IAM instance profile.
         */
        public var iamInstanceProfileName: kotlin.String? = null
        /**
         * The instance type to use when launching the server.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The logical ID of the server in the CloudFormation template.
         */
        public var logicalId: kotlin.String? = null
        /**
         * The ID of the security group that applies to the launched server.
         */
        public var securityGroup: kotlin.String? = null
        /**
         * The ID of the server with which the launch configuration is associated.
         */
        public var server: aws.sdk.kotlin.services.sms.model.Server? = null
        /**
         * The ID of the subnet the server should be launched into.
         */
        public var subnet: kotlin.String? = null
        /**
         * Location of the user-data script to be executed when launching the server.
         */
        public var userData: aws.sdk.kotlin.services.sms.model.UserData? = null
        /**
         * The ID of the VPC into which the server should be launched.
         */
        public var vpc: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sms.model.ServerLaunchConfiguration) : this() {
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.configureScript = x.configureScript
            this.configureScriptType = x.configureScriptType
            this.ec2KeyName = x.ec2KeyName
            this.iamInstanceProfileName = x.iamInstanceProfileName
            this.instanceType = x.instanceType
            this.logicalId = x.logicalId
            this.securityGroup = x.securityGroup
            this.server = x.server
            this.subnet = x.subnet
            this.userData = x.userData
            this.vpc = x.vpc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sms.model.ServerLaunchConfiguration = ServerLaunchConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.sms.model.S3Location] inside the given [block]
         */
        public fun configureScript(block: aws.sdk.kotlin.services.sms.model.S3Location.Builder.() -> kotlin.Unit) {
            this.configureScript = aws.sdk.kotlin.services.sms.model.S3Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sms.model.Server] inside the given [block]
         */
        public fun server(block: aws.sdk.kotlin.services.sms.model.Server.Builder.() -> kotlin.Unit) {
            this.server = aws.sdk.kotlin.services.sms.model.Server.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sms.model.UserData] inside the given [block]
         */
        public fun userData(block: aws.sdk.kotlin.services.sms.model.UserData.Builder.() -> kotlin.Unit) {
            this.userData = aws.sdk.kotlin.services.sms.model.UserData.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
