// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a replication run.
 */
public class ReplicationRun private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Machine Image (AMI) from the replication run.
     */
    public val amiId: kotlin.String? = builder.amiId
    /**
     * The completion time of the last replication run.
     */
    public val completedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completedTime
    /**
     * The description of the replication run.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether the replication run should produce an encrypted AMI.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
     * + KMS key ID
     * + KMS key alias
     * + ARN referring to the KMS key ID
     * + ARN referring to the KMS key alias
     *
     *  If encrypted is *true* but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The ID of the replication run.
     */
    public val replicationRunId: kotlin.String? = builder.replicationRunId
    /**
     * The start time of the next replication run.
     */
    public val scheduledStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledStartTime
    /**
     * Details about the current stage of the replication run.
     */
    public val stageDetails: aws.sdk.kotlin.services.sms.model.ReplicationRunStageDetails? = builder.stageDetails
    /**
     * The state of the replication run.
     */
    public val state: aws.sdk.kotlin.services.sms.model.ReplicationRunState? = builder.state
    /**
     * The description of the current status of the replication job.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The type of replication run.
     */
    public val type: aws.sdk.kotlin.services.sms.model.ReplicationRunType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sms.model.ReplicationRun = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationRun(")
        append("amiId=$amiId,")
        append("completedTime=$completedTime,")
        append("description=$description,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("replicationRunId=$replicationRunId,")
        append("scheduledStartTime=$scheduledStartTime,")
        append("stageDetails=$stageDetails,")
        append("state=$state,")
        append("statusMessage=$statusMessage,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiId?.hashCode() ?: 0
        result = 31 * result + (completedTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (replicationRunId?.hashCode() ?: 0)
        result = 31 * result + (scheduledStartTime?.hashCode() ?: 0)
        result = 31 * result + (stageDetails?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationRun

        if (amiId != other.amiId) return false
        if (completedTime != other.completedTime) return false
        if (description != other.description) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (replicationRunId != other.replicationRunId) return false
        if (scheduledStartTime != other.scheduledStartTime) return false
        if (stageDetails != other.stageDetails) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sms.model.ReplicationRun = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Machine Image (AMI) from the replication run.
         */
        public var amiId: kotlin.String? = null
        /**
         * The completion time of the last replication run.
         */
        public var completedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the replication run.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether the replication run should produce an encrypted AMI.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
         * + KMS key ID
         * + KMS key alias
         * + ARN referring to the KMS key ID
         * + ARN referring to the KMS key alias
         *
         *  If encrypted is *true* but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The ID of the replication run.
         */
        public var replicationRunId: kotlin.String? = null
        /**
         * The start time of the next replication run.
         */
        public var scheduledStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details about the current stage of the replication run.
         */
        public var stageDetails: aws.sdk.kotlin.services.sms.model.ReplicationRunStageDetails? = null
        /**
         * The state of the replication run.
         */
        public var state: aws.sdk.kotlin.services.sms.model.ReplicationRunState? = null
        /**
         * The description of the current status of the replication job.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The type of replication run.
         */
        public var type: aws.sdk.kotlin.services.sms.model.ReplicationRunType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sms.model.ReplicationRun) : this() {
            this.amiId = x.amiId
            this.completedTime = x.completedTime
            this.description = x.description
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.replicationRunId = x.replicationRunId
            this.scheduledStartTime = x.scheduledStartTime
            this.stageDetails = x.stageDetails
            this.state = x.state
            this.statusMessage = x.statusMessage
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sms.model.ReplicationRun = ReplicationRun(this)

        /**
         * construct an [aws.sdk.kotlin.services.sms.model.ReplicationRunStageDetails] inside the given [block]
         */
        public fun stageDetails(block: aws.sdk.kotlin.services.sms.model.ReplicationRunStageDetails.Builder.() -> kotlin.Unit) {
            this.stageDetails = aws.sdk.kotlin.services.sms.model.ReplicationRunStageDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
