// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a replication job.
 */
public class ReplicationJob private constructor(builder: Builder) {
    /**
     * The description of the replication job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether the replication job should produce encrypted AMIs.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The time between consecutive replication runs, in hours.
     */
    public val frequency: kotlin.Int? = builder.frequency
    /**
     * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
     * + KMS key ID
     * + KMS key alias
     * + ARN referring to the KMS key ID
     * + ARN referring to the KMS key alias
     *
     * If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The ID of the latest Amazon Machine Image (AMI).
     */
    public val latestAmiId: kotlin.String? = builder.latestAmiId
    /**
     * The license type to be used for the AMI created by a successful replication run.
     */
    public val licenseType: aws.sdk.kotlin.services.sms.model.LicenseType? = builder.licenseType
    /**
     * The start time of the next replication run.
     */
    public val nextReplicationRunStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.nextReplicationRunStartTime
    /**
     * The number of recent AMIs to keep in the customer's account for a replication job. By default, the value is set to zero, meaning that all AMIs are kept.
     */
    public val numberOfRecentAmisToKeep: kotlin.Int? = builder.numberOfRecentAmisToKeep
    /**
     * The ID of the replication job.
     */
    public val replicationJobId: kotlin.String? = builder.replicationJobId
    /**
     * Information about the replication runs.
     */
    public val replicationRunList: List<ReplicationRun>? = builder.replicationRunList
    /**
     * The name of the IAM role to be used by Server Migration Service.
     */
    public val roleName: kotlin.String? = builder.roleName
    /**
     * Indicates whether to run the replication job one time.
     */
    public val runOnce: kotlin.Boolean? = builder.runOnce
    /**
     * The seed replication time.
     */
    public val seedReplicationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.seedReplicationTime
    /**
     * The ID of the server.
     */
    public val serverId: kotlin.String? = builder.serverId
    /**
     * The type of server.
     */
    public val serverType: aws.sdk.kotlin.services.sms.model.ServerType? = builder.serverType
    /**
     * The state of the replication job.
     */
    public val state: aws.sdk.kotlin.services.sms.model.ReplicationJobState? = builder.state
    /**
     * The description of the current status of the replication job.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * Information about the VM server.
     */
    public val vmServer: aws.sdk.kotlin.services.sms.model.VmServer? = builder.vmServer

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sms.model.ReplicationJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationJob(")
        append("description=$description,")
        append("encrypted=$encrypted,")
        append("frequency=$frequency,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestAmiId=$latestAmiId,")
        append("licenseType=$licenseType,")
        append("nextReplicationRunStartTime=$nextReplicationRunStartTime,")
        append("numberOfRecentAmisToKeep=$numberOfRecentAmisToKeep,")
        append("replicationJobId=$replicationJobId,")
        append("replicationRunList=$replicationRunList,")
        append("roleName=$roleName,")
        append("runOnce=$runOnce,")
        append("seedReplicationTime=$seedReplicationTime,")
        append("serverId=$serverId,")
        append("serverType=$serverType,")
        append("state=$state,")
        append("statusMessage=$statusMessage,")
        append("vmServer=$vmServer")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (frequency ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestAmiId?.hashCode() ?: 0)
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (nextReplicationRunStartTime?.hashCode() ?: 0)
        result = 31 * result + (numberOfRecentAmisToKeep ?: 0)
        result = 31 * result + (replicationJobId?.hashCode() ?: 0)
        result = 31 * result + (replicationRunList?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (runOnce?.hashCode() ?: 0)
        result = 31 * result + (seedReplicationTime?.hashCode() ?: 0)
        result = 31 * result + (serverId?.hashCode() ?: 0)
        result = 31 * result + (serverType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (vmServer?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationJob

        if (description != other.description) return false
        if (encrypted != other.encrypted) return false
        if (frequency != other.frequency) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestAmiId != other.latestAmiId) return false
        if (licenseType != other.licenseType) return false
        if (nextReplicationRunStartTime != other.nextReplicationRunStartTime) return false
        if (numberOfRecentAmisToKeep != other.numberOfRecentAmisToKeep) return false
        if (replicationJobId != other.replicationJobId) return false
        if (replicationRunList != other.replicationRunList) return false
        if (roleName != other.roleName) return false
        if (runOnce != other.runOnce) return false
        if (seedReplicationTime != other.seedReplicationTime) return false
        if (serverId != other.serverId) return false
        if (serverType != other.serverType) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false
        if (vmServer != other.vmServer) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sms.model.ReplicationJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the replication job.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether the replication job should produce encrypted AMIs.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The time between consecutive replication runs, in hours.
         */
        public var frequency: kotlin.Int? = null
        /**
         * The ID of the KMS key for replication jobs that produce encrypted AMIs. This value can be any of the following:
         * + KMS key ID
         * + KMS key alias
         * + ARN referring to the KMS key ID
         * + ARN referring to the KMS key alias
         *
         * If encrypted is enabled but a KMS key ID is not specified, the customer's default KMS key for Amazon EBS is used.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The ID of the latest Amazon Machine Image (AMI).
         */
        public var latestAmiId: kotlin.String? = null
        /**
         * The license type to be used for the AMI created by a successful replication run.
         */
        public var licenseType: aws.sdk.kotlin.services.sms.model.LicenseType? = null
        /**
         * The start time of the next replication run.
         */
        public var nextReplicationRunStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of recent AMIs to keep in the customer's account for a replication job. By default, the value is set to zero, meaning that all AMIs are kept.
         */
        public var numberOfRecentAmisToKeep: kotlin.Int? = null
        /**
         * The ID of the replication job.
         */
        public var replicationJobId: kotlin.String? = null
        /**
         * Information about the replication runs.
         */
        public var replicationRunList: List<ReplicationRun>? = null
        /**
         * The name of the IAM role to be used by Server Migration Service.
         */
        public var roleName: kotlin.String? = null
        /**
         * Indicates whether to run the replication job one time.
         */
        public var runOnce: kotlin.Boolean? = null
        /**
         * The seed replication time.
         */
        public var seedReplicationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the server.
         */
        public var serverId: kotlin.String? = null
        /**
         * The type of server.
         */
        public var serverType: aws.sdk.kotlin.services.sms.model.ServerType? = null
        /**
         * The state of the replication job.
         */
        public var state: aws.sdk.kotlin.services.sms.model.ReplicationJobState? = null
        /**
         * The description of the current status of the replication job.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * Information about the VM server.
         */
        public var vmServer: aws.sdk.kotlin.services.sms.model.VmServer? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sms.model.ReplicationJob) : this() {
            this.description = x.description
            this.encrypted = x.encrypted
            this.frequency = x.frequency
            this.kmsKeyId = x.kmsKeyId
            this.latestAmiId = x.latestAmiId
            this.licenseType = x.licenseType
            this.nextReplicationRunStartTime = x.nextReplicationRunStartTime
            this.numberOfRecentAmisToKeep = x.numberOfRecentAmisToKeep
            this.replicationJobId = x.replicationJobId
            this.replicationRunList = x.replicationRunList
            this.roleName = x.roleName
            this.runOnce = x.runOnce
            this.seedReplicationTime = x.seedReplicationTime
            this.serverId = x.serverId
            this.serverType = x.serverType
            this.state = x.state
            this.statusMessage = x.statusMessage
            this.vmServer = x.vmServer
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sms.model.ReplicationJob = ReplicationJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.sms.model.VmServer] inside the given [block]
         */
        public fun vmServer(block: aws.sdk.kotlin.services.sms.model.VmServer.Builder.() -> kotlin.Unit) {
            this.vmServer = aws.sdk.kotlin.services.sms.model.VmServer.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
