// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sms

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.sms.auth.DefaultSmsAuthSchemeProvider
import aws.sdk.kotlin.services.sms.auth.SmsAuthSchemeProvider
import aws.sdk.kotlin.services.sms.endpoints.DefaultSmsEndpointProvider
import aws.sdk.kotlin.services.sms.endpoints.SmsEndpointParameters
import aws.sdk.kotlin.services.sms.endpoints.SmsEndpointProvider
import aws.sdk.kotlin.services.sms.model.CreateAppRequest
import aws.sdk.kotlin.services.sms.model.CreateAppResponse
import aws.sdk.kotlin.services.sms.model.CreateReplicationJobRequest
import aws.sdk.kotlin.services.sms.model.CreateReplicationJobResponse
import aws.sdk.kotlin.services.sms.model.DeleteAppLaunchConfigurationRequest
import aws.sdk.kotlin.services.sms.model.DeleteAppLaunchConfigurationResponse
import aws.sdk.kotlin.services.sms.model.DeleteAppReplicationConfigurationRequest
import aws.sdk.kotlin.services.sms.model.DeleteAppReplicationConfigurationResponse
import aws.sdk.kotlin.services.sms.model.DeleteAppRequest
import aws.sdk.kotlin.services.sms.model.DeleteAppResponse
import aws.sdk.kotlin.services.sms.model.DeleteAppValidationConfigurationRequest
import aws.sdk.kotlin.services.sms.model.DeleteAppValidationConfigurationResponse
import aws.sdk.kotlin.services.sms.model.DeleteReplicationJobRequest
import aws.sdk.kotlin.services.sms.model.DeleteReplicationJobResponse
import aws.sdk.kotlin.services.sms.model.DeleteServerCatalogRequest
import aws.sdk.kotlin.services.sms.model.DeleteServerCatalogResponse
import aws.sdk.kotlin.services.sms.model.DisassociateConnectorRequest
import aws.sdk.kotlin.services.sms.model.DisassociateConnectorResponse
import aws.sdk.kotlin.services.sms.model.GenerateChangeSetRequest
import aws.sdk.kotlin.services.sms.model.GenerateChangeSetResponse
import aws.sdk.kotlin.services.sms.model.GenerateTemplateRequest
import aws.sdk.kotlin.services.sms.model.GenerateTemplateResponse
import aws.sdk.kotlin.services.sms.model.GetAppLaunchConfigurationRequest
import aws.sdk.kotlin.services.sms.model.GetAppLaunchConfigurationResponse
import aws.sdk.kotlin.services.sms.model.GetAppReplicationConfigurationRequest
import aws.sdk.kotlin.services.sms.model.GetAppReplicationConfigurationResponse
import aws.sdk.kotlin.services.sms.model.GetAppRequest
import aws.sdk.kotlin.services.sms.model.GetAppResponse
import aws.sdk.kotlin.services.sms.model.GetAppValidationConfigurationRequest
import aws.sdk.kotlin.services.sms.model.GetAppValidationConfigurationResponse
import aws.sdk.kotlin.services.sms.model.GetAppValidationOutputRequest
import aws.sdk.kotlin.services.sms.model.GetAppValidationOutputResponse
import aws.sdk.kotlin.services.sms.model.GetConnectorsRequest
import aws.sdk.kotlin.services.sms.model.GetConnectorsResponse
import aws.sdk.kotlin.services.sms.model.GetReplicationJobsRequest
import aws.sdk.kotlin.services.sms.model.GetReplicationJobsResponse
import aws.sdk.kotlin.services.sms.model.GetReplicationRunsRequest
import aws.sdk.kotlin.services.sms.model.GetReplicationRunsResponse
import aws.sdk.kotlin.services.sms.model.GetServersRequest
import aws.sdk.kotlin.services.sms.model.GetServersResponse
import aws.sdk.kotlin.services.sms.model.ImportAppCatalogRequest
import aws.sdk.kotlin.services.sms.model.ImportAppCatalogResponse
import aws.sdk.kotlin.services.sms.model.ImportServerCatalogRequest
import aws.sdk.kotlin.services.sms.model.ImportServerCatalogResponse
import aws.sdk.kotlin.services.sms.model.LaunchAppRequest
import aws.sdk.kotlin.services.sms.model.LaunchAppResponse
import aws.sdk.kotlin.services.sms.model.ListAppsRequest
import aws.sdk.kotlin.services.sms.model.ListAppsResponse
import aws.sdk.kotlin.services.sms.model.NotifyAppValidationOutputRequest
import aws.sdk.kotlin.services.sms.model.NotifyAppValidationOutputResponse
import aws.sdk.kotlin.services.sms.model.PutAppLaunchConfigurationRequest
import aws.sdk.kotlin.services.sms.model.PutAppLaunchConfigurationResponse
import aws.sdk.kotlin.services.sms.model.PutAppReplicationConfigurationRequest
import aws.sdk.kotlin.services.sms.model.PutAppReplicationConfigurationResponse
import aws.sdk.kotlin.services.sms.model.PutAppValidationConfigurationRequest
import aws.sdk.kotlin.services.sms.model.PutAppValidationConfigurationResponse
import aws.sdk.kotlin.services.sms.model.StartAppReplicationRequest
import aws.sdk.kotlin.services.sms.model.StartAppReplicationResponse
import aws.sdk.kotlin.services.sms.model.StartOnDemandAppReplicationRequest
import aws.sdk.kotlin.services.sms.model.StartOnDemandAppReplicationResponse
import aws.sdk.kotlin.services.sms.model.StartOnDemandReplicationRunRequest
import aws.sdk.kotlin.services.sms.model.StartOnDemandReplicationRunResponse
import aws.sdk.kotlin.services.sms.model.StopAppReplicationRequest
import aws.sdk.kotlin.services.sms.model.StopAppReplicationResponse
import aws.sdk.kotlin.services.sms.model.TerminateAppRequest
import aws.sdk.kotlin.services.sms.model.TerminateAppResponse
import aws.sdk.kotlin.services.sms.model.UpdateAppRequest
import aws.sdk.kotlin.services.sms.model.UpdateAppResponse
import aws.sdk.kotlin.services.sms.model.UpdateReplicationJobRequest
import aws.sdk.kotlin.services.sms.model.UpdateReplicationJobResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SMS"
public const val SdkVersion: String = "1.0.0"

/**
 * **Product update**
 *
 * We recommend [Amazon Web Services Application Migration Service](http://aws.amazon.com/application-migration-service) (Amazon Web Services MGN) as the primary migration service for lift-and-shift migrations. If Amazon Web Services MGN is unavailable in a specific Amazon Web Services Region, you can use the Server Migration Service APIs through March 2023.
 *
 * Server Migration Service (Server Migration Service) makes it easier and faster for you to migrate your on-premises workloads to Amazon Web Services. To learn more about Server Migration Service, see the following resources:
 * + [Server Migration Service product page](http://aws.amazon.com/server-migration-service/)
 * + [Server Migration Service User Guide](https://docs.aws.amazon.com/server-migration-service/latest/userguide/)
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public interface SmsClient : SdkClient {
    /**
     * SmsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SmsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Sms",
                "SMS",
                "sms",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SmsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SmsClient = DefaultSmsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SmsEndpointProvider = builder.endpointProvider ?: DefaultSmsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SmsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSmsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SMS"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SmsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SmsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an application. An application consists of one or more server groups. Each server group contain one or more servers.
     */
    public suspend fun createApp(input: CreateAppRequest = CreateAppRequest { }): CreateAppResponse

    /**
     * Creates a replication job. The replication job schedules periodic replication runs to replicate your server to Amazon Web Services. Each replication run creates an Amazon Machine Image (AMI).
     */
    public suspend fun createReplicationJob(input: CreateReplicationJobRequest): CreateReplicationJobResponse

    /**
     * Deletes the specified application. Optionally deletes the launched stack associated with the application and all Server Migration Service replication jobs for servers in the application.
     */
    public suspend fun deleteApp(input: DeleteAppRequest = DeleteAppRequest { }): DeleteAppResponse

    /**
     * Deletes the launch configuration for the specified application.
     */
    public suspend fun deleteAppLaunchConfiguration(input: DeleteAppLaunchConfigurationRequest = DeleteAppLaunchConfigurationRequest { }): DeleteAppLaunchConfigurationResponse

    /**
     * Deletes the replication configuration for the specified application.
     */
    public suspend fun deleteAppReplicationConfiguration(input: DeleteAppReplicationConfigurationRequest = DeleteAppReplicationConfigurationRequest { }): DeleteAppReplicationConfigurationResponse

    /**
     * Deletes the validation configuration for the specified application.
     */
    public suspend fun deleteAppValidationConfiguration(input: DeleteAppValidationConfigurationRequest): DeleteAppValidationConfigurationResponse

    /**
     * Deletes the specified replication job.
     *
     * After you delete a replication job, there are no further replication runs. Amazon Web Services deletes the contents of the Amazon S3 bucket used to store Server Migration Service artifacts. The AMIs created by the replication runs are not deleted.
     */
    public suspend fun deleteReplicationJob(input: DeleteReplicationJobRequest): DeleteReplicationJobResponse

    /**
     * Deletes all servers from your server catalog.
     */
    public suspend fun deleteServerCatalog(input: DeleteServerCatalogRequest = DeleteServerCatalogRequest { }): DeleteServerCatalogResponse

    /**
     * Disassociates the specified connector from Server Migration Service.
     *
     * After you disassociate a connector, it is no longer available to support replication jobs.
     */
    public suspend fun disassociateConnector(input: DisassociateConnectorRequest): DisassociateConnectorResponse

    /**
     * Generates a target change set for a currently launched stack and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.
     */
    public suspend fun generateChangeSet(input: GenerateChangeSetRequest = GenerateChangeSetRequest { }): GenerateChangeSetResponse

    /**
     * Generates an CloudFormation template based on the current launch configuration and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.
     */
    public suspend fun generateTemplate(input: GenerateTemplateRequest = GenerateTemplateRequest { }): GenerateTemplateResponse

    /**
     * Retrieve information about the specified application.
     */
    public suspend fun getApp(input: GetAppRequest = GetAppRequest { }): GetAppResponse

    /**
     * Retrieves the application launch configuration associated with the specified application.
     */
    public suspend fun getAppLaunchConfiguration(input: GetAppLaunchConfigurationRequest = GetAppLaunchConfigurationRequest { }): GetAppLaunchConfigurationResponse

    /**
     * Retrieves the application replication configuration associated with the specified application.
     */
    public suspend fun getAppReplicationConfiguration(input: GetAppReplicationConfigurationRequest = GetAppReplicationConfigurationRequest { }): GetAppReplicationConfigurationResponse

    /**
     * Retrieves information about a configuration for validating an application.
     */
    public suspend fun getAppValidationConfiguration(input: GetAppValidationConfigurationRequest): GetAppValidationConfigurationResponse

    /**
     * Retrieves output from validating an application.
     */
    public suspend fun getAppValidationOutput(input: GetAppValidationOutputRequest): GetAppValidationOutputResponse

    /**
     * Describes the connectors registered with the Server Migration Service.
     */
    public suspend fun getConnectors(input: GetConnectorsRequest = GetConnectorsRequest { }): GetConnectorsResponse

    /**
     * Describes the specified replication job or all of your replication jobs.
     */
    public suspend fun getReplicationJobs(input: GetReplicationJobsRequest = GetReplicationJobsRequest { }): GetReplicationJobsResponse

    /**
     * Describes the replication runs for the specified replication job.
     */
    public suspend fun getReplicationRuns(input: GetReplicationRunsRequest): GetReplicationRunsResponse

    /**
     * Describes the servers in your server catalog.
     *
     * Before you can describe your servers, you must import them using ImportServerCatalog.
     */
    public suspend fun getServers(input: GetServersRequest = GetServersRequest { }): GetServersResponse

    /**
     * Allows application import from Migration Hub.
     */
    public suspend fun importAppCatalog(input: ImportAppCatalogRequest = ImportAppCatalogRequest { }): ImportAppCatalogResponse

    /**
     * Gathers a complete list of on-premises servers. Connectors must be installed and monitoring all servers to import.
     *
     * This call returns immediately, but might take additional time to retrieve all the servers.
     */
    public suspend fun importServerCatalog(input: ImportServerCatalogRequest = ImportServerCatalogRequest { }): ImportServerCatalogResponse

    /**
     * Launches the specified application as a stack in CloudFormation.
     */
    public suspend fun launchApp(input: LaunchAppRequest = LaunchAppRequest { }): LaunchAppResponse

    /**
     * Retrieves summaries for all applications.
     */
    public suspend fun listApps(input: ListAppsRequest = ListAppsRequest { }): ListAppsResponse

    /**
     * Provides information to Server Migration Service about whether application validation is successful.
     */
    public suspend fun notifyAppValidationOutput(input: NotifyAppValidationOutputRequest): NotifyAppValidationOutputResponse

    /**
     * Creates or updates the launch configuration for the specified application.
     */
    public suspend fun putAppLaunchConfiguration(input: PutAppLaunchConfigurationRequest = PutAppLaunchConfigurationRequest { }): PutAppLaunchConfigurationResponse

    /**
     * Creates or updates the replication configuration for the specified application.
     */
    public suspend fun putAppReplicationConfiguration(input: PutAppReplicationConfigurationRequest = PutAppReplicationConfigurationRequest { }): PutAppReplicationConfigurationResponse

    /**
     * Creates or updates a validation configuration for the specified application.
     */
    public suspend fun putAppValidationConfiguration(input: PutAppValidationConfigurationRequest): PutAppValidationConfigurationResponse

    /**
     * Starts replicating the specified application by creating replication jobs for each server in the application.
     */
    public suspend fun startAppReplication(input: StartAppReplicationRequest = StartAppReplicationRequest { }): StartAppReplicationResponse

    /**
     * Starts an on-demand replication run for the specified application.
     */
    public suspend fun startOnDemandAppReplication(input: StartOnDemandAppReplicationRequest): StartOnDemandAppReplicationResponse

    /**
     * Starts an on-demand replication run for the specified replication job. This replication run starts immediately. This replication run is in addition to the ones already scheduled.
     *
     * There is a limit on the number of on-demand replications runs that you can request in a 24-hour period.
     */
    public suspend fun startOnDemandReplicationRun(input: StartOnDemandReplicationRunRequest): StartOnDemandReplicationRunResponse

    /**
     * Stops replicating the specified application by deleting the replication job for each server in the application.
     */
    public suspend fun stopAppReplication(input: StopAppReplicationRequest = StopAppReplicationRequest { }): StopAppReplicationResponse

    /**
     * Terminates the stack for the specified application.
     */
    public suspend fun terminateApp(input: TerminateAppRequest = TerminateAppRequest { }): TerminateAppResponse

    /**
     * Updates the specified application.
     */
    public suspend fun updateApp(input: UpdateAppRequest = UpdateAppRequest { }): UpdateAppResponse

    /**
     * Updates the specified settings for the specified replication job.
     */
    public suspend fun updateReplicationJob(input: UpdateReplicationJobRequest): UpdateReplicationJobResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SmsClient.withConfig(block: SmsClient.Config.Builder.() -> Unit): SmsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSmsClient(newConfig)
}

/**
 * Creates an application. An application consists of one or more server groups. Each server group contain one or more servers.
 */
public suspend inline fun SmsClient.createApp(crossinline block: CreateAppRequest.Builder.() -> Unit): CreateAppResponse = createApp(CreateAppRequest.Builder().apply(block).build())

/**
 * Creates a replication job. The replication job schedules periodic replication runs to replicate your server to Amazon Web Services. Each replication run creates an Amazon Machine Image (AMI).
 */
public suspend inline fun SmsClient.createReplicationJob(crossinline block: CreateReplicationJobRequest.Builder.() -> Unit): CreateReplicationJobResponse = createReplicationJob(CreateReplicationJobRequest.Builder().apply(block).build())

/**
 * Deletes the specified application. Optionally deletes the launched stack associated with the application and all Server Migration Service replication jobs for servers in the application.
 */
public suspend inline fun SmsClient.deleteApp(crossinline block: DeleteAppRequest.Builder.() -> Unit): DeleteAppResponse = deleteApp(DeleteAppRequest.Builder().apply(block).build())

/**
 * Deletes the launch configuration for the specified application.
 */
public suspend inline fun SmsClient.deleteAppLaunchConfiguration(crossinline block: DeleteAppLaunchConfigurationRequest.Builder.() -> Unit): DeleteAppLaunchConfigurationResponse = deleteAppLaunchConfiguration(DeleteAppLaunchConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the replication configuration for the specified application.
 */
public suspend inline fun SmsClient.deleteAppReplicationConfiguration(crossinline block: DeleteAppReplicationConfigurationRequest.Builder.() -> Unit): DeleteAppReplicationConfigurationResponse = deleteAppReplicationConfiguration(DeleteAppReplicationConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the validation configuration for the specified application.
 */
public suspend inline fun SmsClient.deleteAppValidationConfiguration(crossinline block: DeleteAppValidationConfigurationRequest.Builder.() -> Unit): DeleteAppValidationConfigurationResponse = deleteAppValidationConfiguration(DeleteAppValidationConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified replication job.
 *
 * After you delete a replication job, there are no further replication runs. Amazon Web Services deletes the contents of the Amazon S3 bucket used to store Server Migration Service artifacts. The AMIs created by the replication runs are not deleted.
 */
public suspend inline fun SmsClient.deleteReplicationJob(crossinline block: DeleteReplicationJobRequest.Builder.() -> Unit): DeleteReplicationJobResponse = deleteReplicationJob(DeleteReplicationJobRequest.Builder().apply(block).build())

/**
 * Deletes all servers from your server catalog.
 */
public suspend inline fun SmsClient.deleteServerCatalog(crossinline block: DeleteServerCatalogRequest.Builder.() -> Unit): DeleteServerCatalogResponse = deleteServerCatalog(DeleteServerCatalogRequest.Builder().apply(block).build())

/**
 * Disassociates the specified connector from Server Migration Service.
 *
 * After you disassociate a connector, it is no longer available to support replication jobs.
 */
public suspend inline fun SmsClient.disassociateConnector(crossinline block: DisassociateConnectorRequest.Builder.() -> Unit): DisassociateConnectorResponse = disassociateConnector(DisassociateConnectorRequest.Builder().apply(block).build())

/**
 * Generates a target change set for a currently launched stack and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.
 */
public suspend inline fun SmsClient.generateChangeSet(crossinline block: GenerateChangeSetRequest.Builder.() -> Unit): GenerateChangeSetResponse = generateChangeSet(GenerateChangeSetRequest.Builder().apply(block).build())

/**
 * Generates an CloudFormation template based on the current launch configuration and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.
 */
public suspend inline fun SmsClient.generateTemplate(crossinline block: GenerateTemplateRequest.Builder.() -> Unit): GenerateTemplateResponse = generateTemplate(GenerateTemplateRequest.Builder().apply(block).build())

/**
 * Retrieve information about the specified application.
 */
public suspend inline fun SmsClient.getApp(crossinline block: GetAppRequest.Builder.() -> Unit): GetAppResponse = getApp(GetAppRequest.Builder().apply(block).build())

/**
 * Retrieves the application launch configuration associated with the specified application.
 */
public suspend inline fun SmsClient.getAppLaunchConfiguration(crossinline block: GetAppLaunchConfigurationRequest.Builder.() -> Unit): GetAppLaunchConfigurationResponse = getAppLaunchConfiguration(GetAppLaunchConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the application replication configuration associated with the specified application.
 */
public suspend inline fun SmsClient.getAppReplicationConfiguration(crossinline block: GetAppReplicationConfigurationRequest.Builder.() -> Unit): GetAppReplicationConfigurationResponse = getAppReplicationConfiguration(GetAppReplicationConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about a configuration for validating an application.
 */
public suspend inline fun SmsClient.getAppValidationConfiguration(crossinline block: GetAppValidationConfigurationRequest.Builder.() -> Unit): GetAppValidationConfigurationResponse = getAppValidationConfiguration(GetAppValidationConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves output from validating an application.
 */
public suspend inline fun SmsClient.getAppValidationOutput(crossinline block: GetAppValidationOutputRequest.Builder.() -> Unit): GetAppValidationOutputResponse = getAppValidationOutput(GetAppValidationOutputRequest.Builder().apply(block).build())

/**
 * Describes the connectors registered with the Server Migration Service.
 */
public suspend inline fun SmsClient.getConnectors(crossinline block: GetConnectorsRequest.Builder.() -> Unit): GetConnectorsResponse = getConnectors(GetConnectorsRequest.Builder().apply(block).build())

/**
 * Describes the specified replication job or all of your replication jobs.
 */
public suspend inline fun SmsClient.getReplicationJobs(crossinline block: GetReplicationJobsRequest.Builder.() -> Unit): GetReplicationJobsResponse = getReplicationJobs(GetReplicationJobsRequest.Builder().apply(block).build())

/**
 * Describes the replication runs for the specified replication job.
 */
public suspend inline fun SmsClient.getReplicationRuns(crossinline block: GetReplicationRunsRequest.Builder.() -> Unit): GetReplicationRunsResponse = getReplicationRuns(GetReplicationRunsRequest.Builder().apply(block).build())

/**
 * Describes the servers in your server catalog.
 *
 * Before you can describe your servers, you must import them using ImportServerCatalog.
 */
public suspend inline fun SmsClient.getServers(crossinline block: GetServersRequest.Builder.() -> Unit): GetServersResponse = getServers(GetServersRequest.Builder().apply(block).build())

/**
 * Allows application import from Migration Hub.
 */
public suspend inline fun SmsClient.importAppCatalog(crossinline block: ImportAppCatalogRequest.Builder.() -> Unit): ImportAppCatalogResponse = importAppCatalog(ImportAppCatalogRequest.Builder().apply(block).build())

/**
 * Gathers a complete list of on-premises servers. Connectors must be installed and monitoring all servers to import.
 *
 * This call returns immediately, but might take additional time to retrieve all the servers.
 */
public suspend inline fun SmsClient.importServerCatalog(crossinline block: ImportServerCatalogRequest.Builder.() -> Unit): ImportServerCatalogResponse = importServerCatalog(ImportServerCatalogRequest.Builder().apply(block).build())

/**
 * Launches the specified application as a stack in CloudFormation.
 */
public suspend inline fun SmsClient.launchApp(crossinline block: LaunchAppRequest.Builder.() -> Unit): LaunchAppResponse = launchApp(LaunchAppRequest.Builder().apply(block).build())

/**
 * Retrieves summaries for all applications.
 */
public suspend inline fun SmsClient.listApps(crossinline block: ListAppsRequest.Builder.() -> Unit): ListAppsResponse = listApps(ListAppsRequest.Builder().apply(block).build())

/**
 * Provides information to Server Migration Service about whether application validation is successful.
 */
public suspend inline fun SmsClient.notifyAppValidationOutput(crossinline block: NotifyAppValidationOutputRequest.Builder.() -> Unit): NotifyAppValidationOutputResponse = notifyAppValidationOutput(NotifyAppValidationOutputRequest.Builder().apply(block).build())

/**
 * Creates or updates the launch configuration for the specified application.
 */
public suspend inline fun SmsClient.putAppLaunchConfiguration(crossinline block: PutAppLaunchConfigurationRequest.Builder.() -> Unit): PutAppLaunchConfigurationResponse = putAppLaunchConfiguration(PutAppLaunchConfigurationRequest.Builder().apply(block).build())

/**
 * Creates or updates the replication configuration for the specified application.
 */
public suspend inline fun SmsClient.putAppReplicationConfiguration(crossinline block: PutAppReplicationConfigurationRequest.Builder.() -> Unit): PutAppReplicationConfigurationResponse = putAppReplicationConfiguration(PutAppReplicationConfigurationRequest.Builder().apply(block).build())

/**
 * Creates or updates a validation configuration for the specified application.
 */
public suspend inline fun SmsClient.putAppValidationConfiguration(crossinline block: PutAppValidationConfigurationRequest.Builder.() -> Unit): PutAppValidationConfigurationResponse = putAppValidationConfiguration(PutAppValidationConfigurationRequest.Builder().apply(block).build())

/**
 * Starts replicating the specified application by creating replication jobs for each server in the application.
 */
public suspend inline fun SmsClient.startAppReplication(crossinline block: StartAppReplicationRequest.Builder.() -> Unit): StartAppReplicationResponse = startAppReplication(StartAppReplicationRequest.Builder().apply(block).build())

/**
 * Starts an on-demand replication run for the specified application.
 */
public suspend inline fun SmsClient.startOnDemandAppReplication(crossinline block: StartOnDemandAppReplicationRequest.Builder.() -> Unit): StartOnDemandAppReplicationResponse = startOnDemandAppReplication(StartOnDemandAppReplicationRequest.Builder().apply(block).build())

/**
 * Starts an on-demand replication run for the specified replication job. This replication run starts immediately. This replication run is in addition to the ones already scheduled.
 *
 * There is a limit on the number of on-demand replications runs that you can request in a 24-hour period.
 */
public suspend inline fun SmsClient.startOnDemandReplicationRun(crossinline block: StartOnDemandReplicationRunRequest.Builder.() -> Unit): StartOnDemandReplicationRunResponse = startOnDemandReplicationRun(StartOnDemandReplicationRunRequest.Builder().apply(block).build())

/**
 * Stops replicating the specified application by deleting the replication job for each server in the application.
 */
public suspend inline fun SmsClient.stopAppReplication(crossinline block: StopAppReplicationRequest.Builder.() -> Unit): StopAppReplicationResponse = stopAppReplication(StopAppReplicationRequest.Builder().apply(block).build())

/**
 * Terminates the stack for the specified application.
 */
public suspend inline fun SmsClient.terminateApp(crossinline block: TerminateAppRequest.Builder.() -> Unit): TerminateAppResponse = terminateApp(TerminateAppRequest.Builder().apply(block).build())

/**
 * Updates the specified application.
 */
public suspend inline fun SmsClient.updateApp(crossinline block: UpdateAppRequest.Builder.() -> Unit): UpdateAppResponse = updateApp(UpdateAppRequest.Builder().apply(block).build())

/**
 * Updates the specified settings for the specified replication job.
 */
public suspend inline fun SmsClient.updateReplicationJob(crossinline block: UpdateReplicationJobRequest.Builder.() -> Unit): UpdateReplicationJobResponse = updateReplicationJob(UpdateReplicationJobRequest.Builder().apply(block).build())
