// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartSimulationRequest private constructor(builder: Builder) {
    /**
     * A value that you provide to ensure that repeated calls to this API operation using the same parameters complete only once. A `ClientToken` is also known as an *idempotency token*. A `ClientToken` expires after 24 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the simulation.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D). The simulation stops when it reaches this limit. The maximum value is `14D`, or its equivalent in the other units. The default value is `14D`. A value equivalent to `0` makes the simulation immediately transition to `Stopping` as soon as it reaches `Started`.
     */
    public val maximumDuration: kotlin.String? = builder.maximumDuration
    /**
     * The name of the simulation.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes to perform actions. For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*. For more information about IAM roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *Identity and Access Management User Guide*.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
     *
     * Provide a `SchemaS3Location` to start your simulation from a schema.
     *
     * If you provide a `SchemaS3Location` then you can't provide a `SnapshotS3Location`.
     */
    public val schemaS3Location: aws.sdk.kotlin.services.simspaceweaver.model.S3Location? = builder.schemaS3Location
    /**
     * The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
     *
     * Provide a `SnapshotS3Location` to start your simulation from a snapshot.
     *
     * The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
     *
     * If you provide a `SnapshotS3Location` then you can't provide a `SchemaS3Location`.
     */
    public val snapshotS3Location: aws.sdk.kotlin.services.simspaceweaver.model.S3Location? = builder.snapshotS3Location
    /**
     * A list of tags for the simulation. For more information about tags, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.simspaceweaver.model.StartSimulationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSimulationRequest(")
        append("clientToken=*** Sensitive Data Redacted ***,")
        append("description=$description,")
        append("maximumDuration=$maximumDuration,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schemaS3Location=$schemaS3Location,")
        append("snapshotS3Location=$snapshotS3Location,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (maximumDuration?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (schemaS3Location?.hashCode() ?: 0)
        result = 31 * result + (snapshotS3Location?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSimulationRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (maximumDuration != other.maximumDuration) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schemaS3Location != other.schemaS3Location) return false
        if (snapshotS3Location != other.snapshotS3Location) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.simspaceweaver.model.StartSimulationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A value that you provide to ensure that repeated calls to this API operation using the same parameters complete only once. A `ClientToken` is also known as an *idempotency token*. A `ClientToken` expires after 24 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description of the simulation.
         */
        public var description: kotlin.String? = null
        /**
         * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D). The simulation stops when it reaches this limit. The maximum value is `14D`, or its equivalent in the other units. The default value is `14D`. A value equivalent to `0` makes the simulation immediately transition to `Stopping` as soon as it reaches `Started`.
         */
        public var maximumDuration: kotlin.String? = null
        /**
         * The name of the simulation.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes to perform actions. For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*. For more information about IAM roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *Identity and Access Management User Guide*.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
         *
         * Provide a `SchemaS3Location` to start your simulation from a schema.
         *
         * If you provide a `SchemaS3Location` then you can't provide a `SnapshotS3Location`.
         */
        public var schemaS3Location: aws.sdk.kotlin.services.simspaceweaver.model.S3Location? = null
        /**
         * The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
         *
         * Provide a `SnapshotS3Location` to start your simulation from a snapshot.
         *
         * The Amazon S3 bucket must be in the same Amazon Web Services Region as the simulation.
         *
         * If you provide a `SnapshotS3Location` then you can't provide a `SchemaS3Location`.
         */
        public var snapshotS3Location: aws.sdk.kotlin.services.simspaceweaver.model.S3Location? = null
        /**
         * A list of tags for the simulation. For more information about tags, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.simspaceweaver.model.StartSimulationRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.maximumDuration = x.maximumDuration
            this.name = x.name
            this.roleArn = x.roleArn
            this.schemaS3Location = x.schemaS3Location
            this.snapshotS3Location = x.snapshotS3Location
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.simspaceweaver.model.StartSimulationRequest = StartSimulationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.simspaceweaver.model.S3Location] inside the given [block]
         */
        public fun schemaS3Location(block: aws.sdk.kotlin.services.simspaceweaver.model.S3Location.Builder.() -> kotlin.Unit) {
            this.schemaS3Location = aws.sdk.kotlin.services.simspaceweaver.model.S3Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.simspaceweaver.model.S3Location] inside the given [block]
         */
        public fun snapshotS3Location(block: aws.sdk.kotlin.services.simspaceweaver.model.S3Location.Builder.() -> kotlin.Unit) {
            this.snapshotS3Location = aws.sdk.kotlin.services.simspaceweaver.model.S3Location.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
