// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeSimulationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC since the Unix epoch (0:0:0.000, January 1, 1970).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the simulation.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A universally unique identifier (UUID) for this simulation.
     */
    public val executionId: kotlin.String? = builder.executionId
    /**
     * A collection of additional state information, such as domain and clock configuration.
     */
    public val liveSimulationState: aws.sdk.kotlin.services.simspaceweaver.model.LiveSimulationState? = builder.liveSimulationState
    /**
     * Settings that control how SimSpace Weaver handles your simulation log data.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.simspaceweaver.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D). The simulation stops when it reaches this limit. The maximum value is `14D`, or its equivalent in the other units. The default value is `14D`. A value equivalent to `0` makes the simulation immediately transition to `Stopping` as soon as it reaches `Started`.
     */
    public val maximumDuration: kotlin.String? = builder.maximumDuration
    /**
     * The name of the simulation.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes to perform actions. For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*. For more information about IAM roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *Identity and Access Management User Guide*.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * An error message that SimSpace Weaver returns only if there is a problem with the simulation schema.
     */
    @Deprecated("SchemaError is no longer used, check StartError instead.")
    public val schemaError: kotlin.String? = builder.schemaError
    /**
     * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
     */
    public val schemaS3Location: aws.sdk.kotlin.services.simspaceweaver.model.S3Location? = builder.schemaS3Location
    /**
     * A location in Amazon Simple Storage Service (Amazon S3) where SimSpace Weaver stores simulation data, such as your app .zip files and schema file. For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
     */
    public val snapshotS3Location: aws.sdk.kotlin.services.simspaceweaver.model.S3Location? = builder.snapshotS3Location
    /**
     * An error message that SimSpace Weaver returns only if a problem occurs when the simulation is in the `STARTING` state.
     */
    public val startError: kotlin.String? = builder.startError
    /**
     * The current lifecycle state of the simulation.
     */
    public val status: aws.sdk.kotlin.services.simspaceweaver.model.SimulationStatus? = builder.status
    /**
     * The desired lifecycle state of the simulation.
     */
    public val targetStatus: aws.sdk.kotlin.services.simspaceweaver.model.SimulationTargetStatus? = builder.targetStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.simspaceweaver.model.DescribeSimulationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSimulationResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("executionId=$executionId,")
        append("liveSimulationState=$liveSimulationState,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("maximumDuration=$maximumDuration,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schemaError=$schemaError,")
        append("schemaS3Location=$schemaS3Location,")
        append("snapshotS3Location=$snapshotS3Location,")
        append("startError=$startError,")
        append("status=$status,")
        append("targetStatus=$targetStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionId?.hashCode() ?: 0)
        result = 31 * result + (liveSimulationState?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (maximumDuration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schemaError?.hashCode() ?: 0)
        result = 31 * result + (schemaS3Location?.hashCode() ?: 0)
        result = 31 * result + (snapshotS3Location?.hashCode() ?: 0)
        result = 31 * result + (startError?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSimulationResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (executionId != other.executionId) return false
        if (liveSimulationState != other.liveSimulationState) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (maximumDuration != other.maximumDuration) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schemaError != other.schemaError) return false
        if (schemaS3Location != other.schemaS3Location) return false
        if (snapshotS3Location != other.snapshotS3Location) return false
        if (startError != other.startError) return false
        if (status != other.status) return false
        if (targetStatus != other.targetStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.simspaceweaver.model.DescribeSimulationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the simulation. For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the simulation was created, expressed as the number of seconds and milliseconds in UTC since the Unix epoch (0:0:0.000, January 1, 1970).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the simulation.
         */
        public var description: kotlin.String? = null
        /**
         * A universally unique identifier (UUID) for this simulation.
         */
        public var executionId: kotlin.String? = null
        /**
         * A collection of additional state information, such as domain and clock configuration.
         */
        public var liveSimulationState: aws.sdk.kotlin.services.simspaceweaver.model.LiveSimulationState? = null
        /**
         * Settings that control how SimSpace Weaver handles your simulation log data.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.simspaceweaver.model.LoggingConfiguration? = null
        /**
         * The maximum running time of the simulation, specified as a number of minutes (m or M), hours (h or H), or days (d or D). The simulation stops when it reaches this limit. The maximum value is `14D`, or its equivalent in the other units. The default value is `14D`. A value equivalent to `0` makes the simulation immediately transition to `Stopping` as soon as it reaches `Started`.
         */
        public var maximumDuration: kotlin.String? = null
        /**
         * The name of the simulation.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that the simulation assumes to perform actions. For more information about ARNs, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*. For more information about IAM roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *Identity and Access Management User Guide*.
         */
        public var roleArn: kotlin.String? = null
        /**
         * An error message that SimSpace Weaver returns only if there is a problem with the simulation schema.
         */
        @Deprecated("SchemaError is no longer used, check StartError instead.")
        public var schemaError: kotlin.String? = null
        /**
         * The location of the simulation schema in Amazon Simple Storage Service (Amazon S3). For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
         */
        public var schemaS3Location: aws.sdk.kotlin.services.simspaceweaver.model.S3Location? = null
        /**
         * A location in Amazon Simple Storage Service (Amazon S3) where SimSpace Weaver stores simulation data, such as your app .zip files and schema file. For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
         */
        public var snapshotS3Location: aws.sdk.kotlin.services.simspaceweaver.model.S3Location? = null
        /**
         * An error message that SimSpace Weaver returns only if a problem occurs when the simulation is in the `STARTING` state.
         */
        public var startError: kotlin.String? = null
        /**
         * The current lifecycle state of the simulation.
         */
        public var status: aws.sdk.kotlin.services.simspaceweaver.model.SimulationStatus? = null
        /**
         * The desired lifecycle state of the simulation.
         */
        public var targetStatus: aws.sdk.kotlin.services.simspaceweaver.model.SimulationTargetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.simspaceweaver.model.DescribeSimulationResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.executionId = x.executionId
            this.liveSimulationState = x.liveSimulationState
            this.loggingConfiguration = x.loggingConfiguration
            this.maximumDuration = x.maximumDuration
            this.name = x.name
            this.roleArn = x.roleArn
            this.schemaError = x.schemaError
            this.schemaS3Location = x.schemaS3Location
            this.snapshotS3Location = x.snapshotS3Location
            this.startError = x.startError
            this.status = x.status
            this.targetStatus = x.targetStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.simspaceweaver.model.DescribeSimulationResponse = DescribeSimulationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.simspaceweaver.model.LiveSimulationState] inside the given [block]
         */
        public fun liveSimulationState(block: aws.sdk.kotlin.services.simspaceweaver.model.LiveSimulationState.Builder.() -> kotlin.Unit) {
            this.liveSimulationState = aws.sdk.kotlin.services.simspaceweaver.model.LiveSimulationState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.simspaceweaver.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.simspaceweaver.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.simspaceweaver.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.simspaceweaver.model.S3Location] inside the given [block]
         */
        public fun schemaS3Location(block: aws.sdk.kotlin.services.simspaceweaver.model.S3Location.Builder.() -> kotlin.Unit) {
            this.schemaS3Location = aws.sdk.kotlin.services.simspaceweaver.model.S3Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.simspaceweaver.model.S3Location] inside the given [block]
         */
        public fun snapshotS3Location(block: aws.sdk.kotlin.services.simspaceweaver.model.S3Location.Builder.() -> kotlin.Unit) {
            this.snapshotS3Location = aws.sdk.kotlin.services.simspaceweaver.model.S3Location.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
