// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An Amazon S3 bucket and optional folder (object key prefix) where SimSpace Weaver creates a file.
 */
public class S3Destination private constructor(builder: Builder) {
    /**
     * The name of an Amazon S3 bucket. For more information about buckets, see [Creating, configuring, and working with Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * A string prefix for an Amazon S3 object key. It's usually a folder name. For more information about folders in Amazon S3, see [Organizing objects in the Amazon S3 console using folders](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val objectKeyPrefix: kotlin.String? = builder.objectKeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.simspaceweaver.model.S3Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Destination(")
        append("bucketName=$bucketName,")
        append("objectKeyPrefix=$objectKeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (objectKeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Destination

        if (bucketName != other.bucketName) return false
        if (objectKeyPrefix != other.objectKeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.simspaceweaver.model.S3Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an Amazon S3 bucket. For more information about buckets, see [Creating, configuring, and working with Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var bucketName: kotlin.String? = null
        /**
         * A string prefix for an Amazon S3 object key. It's usually a folder name. For more information about folders in Amazon S3, see [Organizing objects in the Amazon S3 console using folders](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var objectKeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.simspaceweaver.model.S3Destination) : this() {
            this.bucketName = x.bucketName
            this.objectKeyPrefix = x.objectKeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.simspaceweaver.model.S3Destination = S3Destination(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            return this
        }
    }
}
