// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAppsRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that you want to list apps for.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The maximum number of apps to list.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If SimSpace Weaver returns `nextToken`, then there are more results available. The value of `nextToken` is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then `nextToken` is set to `null`. Each pagination token expires after 24 hours. If you provide a token that isn't valid, then you receive an *HTTP 400 ValidationException* error.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the simulation that you want to list apps for.
     */
    public val simulation: kotlin.String = requireNotNull(builder.simulation) { "A non-null value must be provided for simulation" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.simspaceweaver.model.ListAppsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAppsRequest(")
        append("domain=$domain,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("simulation=$simulation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (simulation.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAppsRequest

        if (domain != other.domain) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (simulation != other.simulation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.simspaceweaver.model.ListAppsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the domain that you want to list apps for.
         */
        public var domain: kotlin.String? = null
        /**
         * The maximum number of apps to list.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If SimSpace Weaver returns `nextToken`, then there are more results available. The value of `nextToken` is a unique pagination token for each page. To retrieve the next page, call the operation again using the returned token. Keep all other arguments unchanged. If no results remain, then `nextToken` is set to `null`. Each pagination token expires after 24 hours. If you provide a token that isn't valid, then you receive an *HTTP 400 ValidationException* error.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the simulation that you want to list apps for.
         */
        public var simulation: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.simspaceweaver.model.ListAppsRequest) : this() {
            this.domain = x.domain
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.simulation = x.simulation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.simspaceweaver.model.ListAppsRequest = ListAppsRequest(this)

        internal fun correctErrors(): Builder {
            if (simulation == null) simulation = ""
            return this
        }
    }
}
