// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.serde

import aws.sdk.kotlin.services.simspaceweaver.model.DescribeAppResponse
import aws.sdk.kotlin.services.simspaceweaver.model.LaunchOverrides
import aws.sdk.kotlin.services.simspaceweaver.model.SimSpaceWeaverException
import aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppEndpointInfo
import aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppStatus
import aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppTargetStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAppOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAppResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAppResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAppError(context, call, payload)
        }
        val builder = DescribeAppResponse.Builder()

        if (payload != null) {
            deserializeDescribeAppOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAppError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SimSpaceWeaverException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SimSpaceWeaverException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAppOperationBody(builder: DescribeAppResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Domain"))
    val ENDPOINTINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndpointInfo"))
    val LAUNCHOVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LaunchOverrides"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SIMULATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Simulation"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TARGETSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(ENDPOINTINFO_DESCRIPTOR)
        field(LAUNCHOVERRIDES_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SIMULATION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TARGETSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOMAIN_DESCRIPTOR.index -> builder.domain = deserializeString()
                ENDPOINTINFO_DESCRIPTOR.index -> builder.endpointInfo = deserializeSimulationAppEndpointInfoDocument(deserializer)
                LAUNCHOVERRIDES_DESCRIPTOR.index -> builder.launchOverrides = deserializeLaunchOverridesDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SIMULATION_DESCRIPTOR.index -> builder.simulation = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SimulationAppStatus.fromValue(it) }
                TARGETSTATUS_DESCRIPTOR.index -> builder.targetStatus = deserializeString().let { SimulationAppTargetStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
