// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.paginators

import aws.sdk.kotlin.services.simspaceweaver.SimSpaceWeaverClient
import aws.sdk.kotlin.services.simspaceweaver.model.ListAppsRequest
import aws.sdk.kotlin.services.simspaceweaver.model.ListAppsResponse
import aws.sdk.kotlin.services.simspaceweaver.model.ListSimulationsRequest
import aws.sdk.kotlin.services.simspaceweaver.model.ListSimulationsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAppsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppsResponse]
 */
public fun SimSpaceWeaverClient.listAppsPaginated(initialRequest: ListAppsRequest): Flow<ListAppsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppsPaginated.listApps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppsResponse]
 */
public fun SimSpaceWeaverClient.listAppsPaginated(block: ListAppsRequest.Builder.() -> Unit): Flow<ListAppsResponse> =
    listAppsPaginated(ListAppsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSimulationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSimulationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationsResponse]
 */
public fun SimSpaceWeaverClient.listSimulationsPaginated(initialRequest: ListSimulationsRequest = ListSimulationsRequest { }): Flow<ListSimulationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSimulationsPaginated.listSimulations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSimulationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationsResponse]
 */
public fun SimSpaceWeaverClient.listSimulationsPaginated(block: ListSimulationsRequest.Builder.() -> Unit): Flow<ListSimulationsResponse> =
    listSimulationsPaginated(ListSimulationsRequest.Builder().apply(block).build())
