// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.simspaceweaver.auth.DefaultSimSpaceWeaverAuthSchemeProvider
import aws.sdk.kotlin.services.simspaceweaver.auth.SimSpaceWeaverAuthSchemeProvider
import aws.sdk.kotlin.services.simspaceweaver.endpoints.DefaultSimSpaceWeaverEndpointProvider
import aws.sdk.kotlin.services.simspaceweaver.endpoints.SimSpaceWeaverEndpointParameters
import aws.sdk.kotlin.services.simspaceweaver.endpoints.SimSpaceWeaverEndpointProvider
import aws.sdk.kotlin.services.simspaceweaver.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.simspaceweaver.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.simspaceweaver.model.DeleteAppRequest
import aws.sdk.kotlin.services.simspaceweaver.model.DeleteAppResponse
import aws.sdk.kotlin.services.simspaceweaver.model.DeleteSimulationRequest
import aws.sdk.kotlin.services.simspaceweaver.model.DeleteSimulationResponse
import aws.sdk.kotlin.services.simspaceweaver.model.DescribeAppRequest
import aws.sdk.kotlin.services.simspaceweaver.model.DescribeAppResponse
import aws.sdk.kotlin.services.simspaceweaver.model.DescribeSimulationRequest
import aws.sdk.kotlin.services.simspaceweaver.model.DescribeSimulationResponse
import aws.sdk.kotlin.services.simspaceweaver.model.ListAppsRequest
import aws.sdk.kotlin.services.simspaceweaver.model.ListAppsResponse
import aws.sdk.kotlin.services.simspaceweaver.model.ListSimulationsRequest
import aws.sdk.kotlin.services.simspaceweaver.model.ListSimulationsResponse
import aws.sdk.kotlin.services.simspaceweaver.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.simspaceweaver.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.simspaceweaver.model.StartAppRequest
import aws.sdk.kotlin.services.simspaceweaver.model.StartAppResponse
import aws.sdk.kotlin.services.simspaceweaver.model.StartClockRequest
import aws.sdk.kotlin.services.simspaceweaver.model.StartClockResponse
import aws.sdk.kotlin.services.simspaceweaver.model.StartSimulationRequest
import aws.sdk.kotlin.services.simspaceweaver.model.StartSimulationResponse
import aws.sdk.kotlin.services.simspaceweaver.model.StopAppRequest
import aws.sdk.kotlin.services.simspaceweaver.model.StopAppResponse
import aws.sdk.kotlin.services.simspaceweaver.model.StopClockRequest
import aws.sdk.kotlin.services.simspaceweaver.model.StopClockResponse
import aws.sdk.kotlin.services.simspaceweaver.model.StopSimulationRequest
import aws.sdk.kotlin.services.simspaceweaver.model.StopSimulationResponse
import aws.sdk.kotlin.services.simspaceweaver.model.TagResourceRequest
import aws.sdk.kotlin.services.simspaceweaver.model.TagResourceResponse
import aws.sdk.kotlin.services.simspaceweaver.model.UntagResourceRequest
import aws.sdk.kotlin.services.simspaceweaver.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SimSpaceWeaver"
public const val SdkVersion: String = "1.2.27"
public const val ServiceApiVersion: String = "2022-10-28"

/**
 * SimSpace Weaver (SimSpace Weaver) is a service that you can use to build and run large-scale spatial simulations in the Amazon Web Services Cloud. For example, you can create crowd simulations, large real-world environments, and immersive and interactive experiences. For more information about SimSpace Weaver, see the *[SimSpace Weaver User Guide](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/)*.
 *
 * This API reference describes the API operations and data types that you can use to communicate directly with SimSpace Weaver.
 *
 * SimSpace Weaver also provides the SimSpace Weaver app SDK, which you use for app development. The SimSpace Weaver app SDK API reference is included in the SimSpace Weaver app SDK documentation. This documentation is part of the SimSpace Weaver app SDK distributable package.
 */
public interface SimSpaceWeaverClient : SdkClient {
    /**
     * SimSpaceWeaverClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SimSpaceWeaverClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "SimSpaceWeaver",
                "SIMSPACEWEAVER",
                "simspaceweaver",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SimSpaceWeaverClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SimSpaceWeaverClient = DefaultSimSpaceWeaverClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SimSpaceWeaverEndpointProvider = builder.endpointProvider ?: DefaultSimSpaceWeaverEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SimSpaceWeaverAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSimSpaceWeaverAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SimSpaceWeaver"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SimSpaceWeaverEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SimSpaceWeaverAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a snapshot of the specified simulation. A snapshot is a file that contains simulation state data at a specific time. The state data saved in a snapshot includes entity data from the State Fabric, the simulation configuration specified in the schema, and the clock tick number. You can use the snapshot to initialize a new simulation. For more information about snapshots, see [Snapshots](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html) in the *SimSpace Weaver User Guide*.
     *
     * You specify a `Destination` when you create a snapshot. The `Destination` is the name of an Amazon S3 bucket and an optional `ObjectKeyPrefix`. The `ObjectKeyPrefix` is usually the name of a folder in the bucket. SimSpace Weaver creates a `snapshot` folder inside the `Destination` and places the snapshot file there.
     *
     * The snapshot file is an Amazon S3 object. It has an object key with the form: ` <i>object-key-prefix</i>/snapshot/<i>simulation-name</i>-<i>YYMMdd</i>-<i>HHmm</i>-<i>ss</i>.zip`, where:
     * + ` <i>YY</i> ` is the 2-digit year
     * + ` <i>MM</i> ` is the 2-digit month
     * + ` <i>dd</i> ` is the 2-digit day of the month
     * + ` <i>HH</i> ` is the 2-digit hour (24-hour clock)
     * + ` <i>mm</i> ` is the 2-digit minutes
     * + ` <i>ss</i> ` is the 2-digit seconds
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Deletes the instance of the given custom app.
     */
    public suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse

    /**
     * Deletes all SimSpace Weaver resources assigned to the given simulation.
     *
     * Your simulation uses resources in other Amazon Web Services. This API operation doesn't delete resources in other Amazon Web Services.
     */
    public suspend fun deleteSimulation(input: DeleteSimulationRequest): DeleteSimulationResponse

    /**
     * Returns the state of the given custom app.
     */
    public suspend fun describeApp(input: DescribeAppRequest): DescribeAppResponse

    /**
     * Returns the current state of the given simulation.
     */
    public suspend fun describeSimulation(input: DescribeSimulationRequest): DescribeSimulationResponse

    /**
     * Lists all custom apps or service apps for the given simulation and domain.
     */
    public suspend fun listApps(input: ListAppsRequest): ListAppsResponse

    /**
     * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
     */
    public suspend fun listSimulations(input: ListSimulationsRequest = ListSimulationsRequest { }): ListSimulationsResponse

    /**
     * Lists all tags on a SimSpace Weaver resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts a custom app with the configuration specified in the simulation schema.
     */
    public suspend fun startApp(input: StartAppRequest): StartAppResponse

    /**
     * Starts the simulation clock.
     */
    public suspend fun startClock(input: StartClockRequest): StartClockResponse

    /**
     * Starts a simulation with the given name. You must choose to start your simulation from a schema or from a snapshot. For more information about the schema, see the [schema reference](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/schema-reference.html) in the *SimSpace Weaver User Guide*. For more information about snapshots, see [Snapshots](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html) in the *SimSpace Weaver User Guide*.
     */
    public suspend fun startSimulation(input: StartSimulationRequest): StartSimulationResponse

    /**
     * Stops the given custom app and shuts down all of its allocated compute resources.
     */
    public suspend fun stopApp(input: StopAppRequest): StopAppResponse

    /**
     * Stops the simulation clock.
     */
    public suspend fun stopClock(input: StopClockRequest): StopClockResponse

    /**
     * Stops the given simulation.
     *
     * You can't restart a simulation after you stop it. If you want to restart a simulation, then you must stop it, delete it, and start a new instance of it.
     */
    public suspend fun stopSimulation(input: StopSimulationRequest): StopSimulationResponse

    /**
     * Adds tags to a SimSpace Weaver resource. For more information about tags, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a SimSpace Weaver resource. For more information about tags, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SimSpaceWeaverClient.withConfig(block: SimSpaceWeaverClient.Config.Builder.() -> Unit): SimSpaceWeaverClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSimSpaceWeaverClient(newConfig)
}

/**
 * Creates a snapshot of the specified simulation. A snapshot is a file that contains simulation state data at a specific time. The state data saved in a snapshot includes entity data from the State Fabric, the simulation configuration specified in the schema, and the clock tick number. You can use the snapshot to initialize a new simulation. For more information about snapshots, see [Snapshots](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html) in the *SimSpace Weaver User Guide*.
 *
 * You specify a `Destination` when you create a snapshot. The `Destination` is the name of an Amazon S3 bucket and an optional `ObjectKeyPrefix`. The `ObjectKeyPrefix` is usually the name of a folder in the bucket. SimSpace Weaver creates a `snapshot` folder inside the `Destination` and places the snapshot file there.
 *
 * The snapshot file is an Amazon S3 object. It has an object key with the form: ` <i>object-key-prefix</i>/snapshot/<i>simulation-name</i>-<i>YYMMdd</i>-<i>HHmm</i>-<i>ss</i>.zip`, where:
 * + ` <i>YY</i> ` is the 2-digit year
 * + ` <i>MM</i> ` is the 2-digit month
 * + ` <i>dd</i> ` is the 2-digit day of the month
 * + ` <i>HH</i> ` is the 2-digit hour (24-hour clock)
 * + ` <i>mm</i> ` is the 2-digit minutes
 * + ` <i>ss</i> ` is the 2-digit seconds
 */
public suspend inline fun SimSpaceWeaverClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes the instance of the given custom app.
 */
public suspend inline fun SimSpaceWeaverClient.deleteApp(crossinline block: DeleteAppRequest.Builder.() -> Unit): DeleteAppResponse = deleteApp(DeleteAppRequest.Builder().apply(block).build())

/**
 * Deletes all SimSpace Weaver resources assigned to the given simulation.
 *
 * Your simulation uses resources in other Amazon Web Services. This API operation doesn't delete resources in other Amazon Web Services.
 */
public suspend inline fun SimSpaceWeaverClient.deleteSimulation(crossinline block: DeleteSimulationRequest.Builder.() -> Unit): DeleteSimulationResponse = deleteSimulation(DeleteSimulationRequest.Builder().apply(block).build())

/**
 * Returns the state of the given custom app.
 */
public suspend inline fun SimSpaceWeaverClient.describeApp(crossinline block: DescribeAppRequest.Builder.() -> Unit): DescribeAppResponse = describeApp(DescribeAppRequest.Builder().apply(block).build())

/**
 * Returns the current state of the given simulation.
 */
public suspend inline fun SimSpaceWeaverClient.describeSimulation(crossinline block: DescribeSimulationRequest.Builder.() -> Unit): DescribeSimulationResponse = describeSimulation(DescribeSimulationRequest.Builder().apply(block).build())

/**
 * Lists all custom apps or service apps for the given simulation and domain.
 */
public suspend inline fun SimSpaceWeaverClient.listApps(crossinline block: ListAppsRequest.Builder.() -> Unit): ListAppsResponse = listApps(ListAppsRequest.Builder().apply(block).build())

/**
 * Lists the SimSpace Weaver simulations in the Amazon Web Services account used to make the API call.
 */
public suspend inline fun SimSpaceWeaverClient.listSimulations(crossinline block: ListSimulationsRequest.Builder.() -> Unit): ListSimulationsResponse = listSimulations(ListSimulationsRequest.Builder().apply(block).build())

/**
 * Lists all tags on a SimSpace Weaver resource.
 */
public suspend inline fun SimSpaceWeaverClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts a custom app with the configuration specified in the simulation schema.
 */
public suspend inline fun SimSpaceWeaverClient.startApp(crossinline block: StartAppRequest.Builder.() -> Unit): StartAppResponse = startApp(StartAppRequest.Builder().apply(block).build())

/**
 * Starts the simulation clock.
 */
public suspend inline fun SimSpaceWeaverClient.startClock(crossinline block: StartClockRequest.Builder.() -> Unit): StartClockResponse = startClock(StartClockRequest.Builder().apply(block).build())

/**
 * Starts a simulation with the given name. You must choose to start your simulation from a schema or from a snapshot. For more information about the schema, see the [schema reference](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/schema-reference.html) in the *SimSpace Weaver User Guide*. For more information about snapshots, see [Snapshots](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html) in the *SimSpace Weaver User Guide*.
 */
public suspend inline fun SimSpaceWeaverClient.startSimulation(crossinline block: StartSimulationRequest.Builder.() -> Unit): StartSimulationResponse = startSimulation(StartSimulationRequest.Builder().apply(block).build())

/**
 * Stops the given custom app and shuts down all of its allocated compute resources.
 */
public suspend inline fun SimSpaceWeaverClient.stopApp(crossinline block: StopAppRequest.Builder.() -> Unit): StopAppResponse = stopApp(StopAppRequest.Builder().apply(block).build())

/**
 * Stops the simulation clock.
 */
public suspend inline fun SimSpaceWeaverClient.stopClock(crossinline block: StopClockRequest.Builder.() -> Unit): StopClockResponse = stopClock(StopClockRequest.Builder().apply(block).build())

/**
 * Stops the given simulation.
 *
 * You can't restart a simulation after you stop it. If you want to restart a simulation, then you must stop it, delete it, and start a new instance of it.
 */
public suspend inline fun SimSpaceWeaverClient.stopSimulation(crossinline block: StopSimulationRequest.Builder.() -> Unit): StopSimulationResponse = stopSimulation(StopSimulationRequest.Builder().apply(block).build())

/**
 * Adds tags to a SimSpace Weaver resource. For more information about tags, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
 */
public suspend inline fun SimSpaceWeaverClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a SimSpace Weaver resource. For more information about tags, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference*.
 */
public suspend inline fun SimSpaceWeaverClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
