// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.serde

import aws.sdk.kotlin.services.simspaceweaver.model.DescribeSimulationResponse
import aws.sdk.kotlin.services.simspaceweaver.model.LiveSimulationState
import aws.sdk.kotlin.services.simspaceweaver.model.LoggingConfiguration
import aws.sdk.kotlin.services.simspaceweaver.model.S3Location
import aws.sdk.kotlin.services.simspaceweaver.model.SimSpaceWeaverException
import aws.sdk.kotlin.services.simspaceweaver.model.SimulationStatus
import aws.sdk.kotlin.services.simspaceweaver.model.SimulationTargetStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeSimulationOperationDeserializer: HttpDeserialize<DescribeSimulationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeSimulationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeSimulationError(context, call)
        }
        val builder = DescribeSimulationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSimulationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeSimulationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SimSpaceWeaverException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SimSpaceWeaverException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSimulationOperationBody(builder: DescribeSimulationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val EXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionId"))
    val LIVESIMULATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LiveSimulationState"))
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfiguration"))
    val MAXIMUMDURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MaximumDuration"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val SCHEMAERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SchemaError"))
    val SCHEMAS3LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SchemaS3Location"))
    val SNAPSHOTS3LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SnapshotS3Location"))
    val STARTERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartError"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TARGETSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXECUTIONID_DESCRIPTOR)
        field(LIVESIMULATIONSTATE_DESCRIPTOR)
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
        field(MAXIMUMDURATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SCHEMAERROR_DESCRIPTOR)
        field(SCHEMAS3LOCATION_DESCRIPTOR)
        field(SNAPSHOTS3LOCATION_DESCRIPTOR)
        field(STARTERROR_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TARGETSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EXECUTIONID_DESCRIPTOR.index -> builder.executionId = deserializeString()
                LIVESIMULATIONSTATE_DESCRIPTOR.index -> builder.liveSimulationState = deserializeLiveSimulationStateDocument(deserializer)
                LOGGINGCONFIGURATION_DESCRIPTOR.index -> builder.loggingConfiguration = deserializeLoggingConfigurationDocument(deserializer)
                MAXIMUMDURATION_DESCRIPTOR.index -> builder.maximumDuration = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SCHEMAERROR_DESCRIPTOR.index -> builder.schemaError = deserializeString()
                SCHEMAS3LOCATION_DESCRIPTOR.index -> builder.schemaS3Location = deserializeS3LocationDocument(deserializer)
                SNAPSHOTS3LOCATION_DESCRIPTOR.index -> builder.snapshotS3Location = deserializeS3LocationDocument(deserializer)
                STARTERROR_DESCRIPTOR.index -> builder.startError = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SimulationStatus.fromValue(it) }
                TARGETSTATUS_DESCRIPTOR.index -> builder.targetStatus = deserializeString().let { SimulationTargetStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
