// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.model



/**
 * Information about the network endpoint that you can use to connect to your custom or service app. For more information about SimSpace Weaver apps, see [Key concepts: Apps](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_apps) in the *SimSpace Weaver User Guide*..
 */
public class SimulationAppEndpointInfo private constructor(builder: Builder) {
    /**
     * The IP address of the app. SimSpace Weaver dynamically assigns this IP address when the app starts.
     */
    public val address: kotlin.String? = builder.address
    /**
     * The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a network endpoint.
     */
    public val ingressPortMappings: List<SimulationAppPortMapping>? = builder.ingressPortMappings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppEndpointInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SimulationAppEndpointInfo(")
        append("address=$address,")
        append("ingressPortMappings=$ingressPortMappings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (ingressPortMappings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SimulationAppEndpointInfo

        if (address != other.address) return false
        if (ingressPortMappings != other.ingressPortMappings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppEndpointInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IP address of the app. SimSpace Weaver dynamically assigns this IP address when the app starts.
         */
        public var address: kotlin.String? = null
        /**
         * The inbound TCP/UDP port numbers of the app. The combination of an IP address and a port number form a network endpoint.
         */
        public var ingressPortMappings: List<SimulationAppPortMapping>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppEndpointInfo) : this() {
            this.address = x.address
            this.ingressPortMappings = x.ingressPortMappings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppEndpointInfo = SimulationAppEndpointInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
