// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.model



/**
 * A location in Amazon Simple Storage Service (Amazon S3) where SimSpace Weaver stores simulation data, such as your app .zip files and schema file. For more information about Amazon S3, see the *Amazon Simple Storage Service User Guide*[](https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
 */
public class S3Location private constructor(builder: Builder) {
    /**
     * The name of an Amazon S3 bucket. For more information about buckets, see [Creating, configuring, and working with Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The key name of an object in Amazon S3. For more information about Amazon S3 objects and object keys, see [Uploading, downloading, and working with objects in Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/uploading-downloading-objects.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val objectKey: kotlin.String = requireNotNull(builder.objectKey) { "A non-null value must be provided for objectKey" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.simspaceweaver.model.S3Location = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Location(")
        append("bucketName=$bucketName,")
        append("objectKey=$objectKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (objectKey.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Location

        if (bucketName != other.bucketName) return false
        if (objectKey != other.objectKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.simspaceweaver.model.S3Location = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of an Amazon S3 bucket. For more information about buckets, see [Creating, configuring, and working with Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The key name of an object in Amazon S3. For more information about Amazon S3 objects and object keys, see [Uploading, downloading, and working with objects in Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/uploading-downloading-objects.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var objectKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.simspaceweaver.model.S3Location) : this() {
            this.bucketName = x.bucketName
            this.objectKey = x.objectKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.simspaceweaver.model.S3Location = S3Location(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (objectKey == null) objectKey = ""
            return this
        }
    }
}
