// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.model



/**
 * A collection of app instances that run the same executable app code and have the same launch options and commands.
 *
 * For more information about domains, see [Key concepts: Domains](https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains) in the *SimSpace Weaver User Guide*.
 */
public class Domain private constructor(builder: Builder) {
    /**
     * The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are *managed* (SimSpace Weaver starts and stops the apps) or *unmanaged* (you must start and stop the apps).
     *
     * **Lifecycle types**
     * + `PerWorker` – Managed: SimSpace Weaver starts one app on each worker.
     * + `BySpatialSubdivision` – Managed: SimSpace Weaver starts one app for each spatial partition.
     * + `ByRequest` – Unmanaged: You use the `StartApp` API to start the apps and use the `StopApp` API to stop the apps.
     */
    public val lifecycle: aws.sdk.kotlin.services.simspaceweaver.model.LifecycleManagementStrategy? = builder.lifecycle
    /**
     * The name of the domain.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.simspaceweaver.model.Domain = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Domain(")
        append("lifecycle=$lifecycle,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lifecycle?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Domain

        if (lifecycle != other.lifecycle) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.simspaceweaver.model.Domain = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of lifecycle management for apps in the domain. Indicates whether apps in this domain are *managed* (SimSpace Weaver starts and stops the apps) or *unmanaged* (you must start and stop the apps).
         *
         * **Lifecycle types**
         * + `PerWorker` – Managed: SimSpace Weaver starts one app on each worker.
         * + `BySpatialSubdivision` – Managed: SimSpace Weaver starts one app for each spatial partition.
         * + `ByRequest` – Unmanaged: You use the `StartApp` API to start the apps and use the `StopApp` API to stop the apps.
         */
        public var lifecycle: aws.sdk.kotlin.services.simspaceweaver.model.LifecycleManagementStrategy? = null
        /**
         * The name of the domain.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.simspaceweaver.model.Domain) : this() {
            this.lifecycle = x.lifecycle
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.simspaceweaver.model.Domain = Domain(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
