// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.simspaceweaver.transform

import aws.sdk.kotlin.services.simspaceweaver.model.DescribeAppResponse
import aws.sdk.kotlin.services.simspaceweaver.model.LaunchOverrides
import aws.sdk.kotlin.services.simspaceweaver.model.SimSpaceWeaverException
import aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppEndpointInfo
import aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppStatus
import aws.sdk.kotlin.services.simspaceweaver.model.SimulationAppTargetStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAppOperationDeserializer: HttpDeserialize<DescribeAppResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAppResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAppError(context, response)
        }
        val builder = DescribeAppResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAppOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAppError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SimSpaceWeaverException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SimSpaceWeaverException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAppOperationBody(builder: DescribeAppResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Domain"))
    val ENDPOINTINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndpointInfo"))
    val LAUNCHOVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LaunchOverrides"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SIMULATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Simulation"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TARGETSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(ENDPOINTINFO_DESCRIPTOR)
        field(LAUNCHOVERRIDES_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SIMULATION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TARGETSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOMAIN_DESCRIPTOR.index -> builder.domain = deserializeString()
                ENDPOINTINFO_DESCRIPTOR.index -> builder.endpointInfo = deserializeSimulationAppEndpointInfoDocument(deserializer)
                LAUNCHOVERRIDES_DESCRIPTOR.index -> builder.launchOverrides = deserializeLaunchOverridesDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SIMULATION_DESCRIPTOR.index -> builder.simulation = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SimulationAppStatus.fromValue(it) }
                TARGETSTATUS_DESCRIPTOR.index -> builder.targetStatus = deserializeString().let { SimulationAppTargetStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
