// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.waiters

import aws.sdk.kotlin.services.signer.SignerClient
import aws.sdk.kotlin.services.signer.model.DescribeSigningJobRequest
import aws.sdk.kotlin.services.signer.model.DescribeSigningJobResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun SignerClient.waitUntilSuccessfulSigningJob(request: DescribeSigningJobRequest): Outcome<DescribeSigningJobResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 20_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeSigningJobRequest, DescribeSigningJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "Succeeded"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeSigningJob(request) }
}

public suspend fun SignerClient.waitUntilSuccessfulSigningJob(block: DescribeSigningJobRequest.Builder.() -> Unit): Outcome<DescribeSigningJobResponse> =
    waitUntilSuccessfulSigningJob(DescribeSigningJobRequest.Builder().apply(block).build())
