// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the ACM certificates and signing configuration parameters that can be used by a given code signing user.
 */
public class SigningProfile private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the signing profile.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the signing platform.
     */
    public val platformDisplayName: kotlin.String? = builder.platformDisplayName
    /**
     * The ID of a platform that is available for use by a signing profile.
     */
    public val platformId: kotlin.String? = builder.platformId
    /**
     * The name of the signing profile.
     */
    public val profileName: kotlin.String? = builder.profileName
    /**
     * The version of a signing profile.
     */
    public val profileVersion: kotlin.String? = builder.profileVersion
    /**
     * The ARN of a signing profile, including the profile version.
     */
    public val profileVersionArn: kotlin.String? = builder.profileVersionArn
    /**
     * The validity period for a signing job created using this signing profile.
     */
    public val signatureValidityPeriod: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod? = builder.signatureValidityPeriod
    /**
     * The ACM certificate that is available for use by a signing profile.
     */
    public val signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = builder.signingMaterial
    /**
     * The parameters that are available for use by a Signer user.
     */
    public val signingParameters: Map<String, String>? = builder.signingParameters
    /**
     * The status of a signing profile.
     */
    public val status: aws.sdk.kotlin.services.signer.model.SigningProfileStatus? = builder.status
    /**
     * A list of tags associated with the signing profile.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.SigningProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SigningProfile(")
        append("arn=$arn,")
        append("platformDisplayName=$platformDisplayName,")
        append("platformId=$platformId,")
        append("profileName=$profileName,")
        append("profileVersion=$profileVersion,")
        append("profileVersionArn=$profileVersionArn,")
        append("signatureValidityPeriod=$signatureValidityPeriod,")
        append("signingMaterial=$signingMaterial,")
        append("signingParameters=$signingParameters,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (platformDisplayName?.hashCode() ?: 0)
        result = 31 * result + (platformId?.hashCode() ?: 0)
        result = 31 * result + (profileName?.hashCode() ?: 0)
        result = 31 * result + (profileVersion?.hashCode() ?: 0)
        result = 31 * result + (profileVersionArn?.hashCode() ?: 0)
        result = 31 * result + (signatureValidityPeriod?.hashCode() ?: 0)
        result = 31 * result + (signingMaterial?.hashCode() ?: 0)
        result = 31 * result + (signingParameters?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SigningProfile

        if (arn != other.arn) return false
        if (platformDisplayName != other.platformDisplayName) return false
        if (platformId != other.platformId) return false
        if (profileName != other.profileName) return false
        if (profileVersion != other.profileVersion) return false
        if (profileVersionArn != other.profileVersionArn) return false
        if (signatureValidityPeriod != other.signatureValidityPeriod) return false
        if (signingMaterial != other.signingMaterial) return false
        if (signingParameters != other.signingParameters) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.SigningProfile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the signing profile.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the signing platform.
         */
        public var platformDisplayName: kotlin.String? = null
        /**
         * The ID of a platform that is available for use by a signing profile.
         */
        public var platformId: kotlin.String? = null
        /**
         * The name of the signing profile.
         */
        public var profileName: kotlin.String? = null
        /**
         * The version of a signing profile.
         */
        public var profileVersion: kotlin.String? = null
        /**
         * The ARN of a signing profile, including the profile version.
         */
        public var profileVersionArn: kotlin.String? = null
        /**
         * The validity period for a signing job created using this signing profile.
         */
        public var signatureValidityPeriod: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod? = null
        /**
         * The ACM certificate that is available for use by a signing profile.
         */
        public var signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = null
        /**
         * The parameters that are available for use by a Signer user.
         */
        public var signingParameters: Map<String, String>? = null
        /**
         * The status of a signing profile.
         */
        public var status: aws.sdk.kotlin.services.signer.model.SigningProfileStatus? = null
        /**
         * A list of tags associated with the signing profile.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.SigningProfile) : this() {
            this.arn = x.arn
            this.platformDisplayName = x.platformDisplayName
            this.platformId = x.platformId
            this.profileName = x.profileName
            this.profileVersion = x.profileVersion
            this.profileVersionArn = x.profileVersionArn
            this.signatureValidityPeriod = x.signatureValidityPeriod
            this.signingMaterial = x.signingMaterial
            this.signingParameters = x.signingParameters
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.SigningProfile = SigningProfile(this)

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod] inside the given [block]
         */
        public fun signatureValidityPeriod(block: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod.Builder.() -> kotlin.Unit) {
            this.signatureValidityPeriod = aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningMaterial] inside the given [block]
         */
        public fun signingMaterial(block: aws.sdk.kotlin.services.signer.model.SigningMaterial.Builder.() -> kotlin.Unit) {
            this.signingMaterial = aws.sdk.kotlin.services.signer.model.SigningMaterial.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
