// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a signing job.
 */
public class SigningJob private constructor(builder: Builder) {
    /**
     * The date and time that the signing job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Indicates whether the signing job is revoked.
     */
    public val isRevoked: kotlin.Boolean = builder.isRevoked
    /**
     * The ID of the signing job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The AWS account ID of the job invoker.
     */
    public val jobInvoker: kotlin.String? = builder.jobInvoker
    /**
     * The AWS account ID of the job owner.
     */
    public val jobOwner: kotlin.String? = builder.jobOwner
    /**
     * The name of a signing platform.
     */
    public val platformDisplayName: kotlin.String? = builder.platformDisplayName
    /**
     * The unique identifier for a signing platform.
     */
    public val platformId: kotlin.String? = builder.platformId
    /**
     * The name of the signing profile that created a signing job.
     */
    public val profileName: kotlin.String? = builder.profileName
    /**
     * The version of the signing profile that created a signing job.
     */
    public val profileVersion: kotlin.String? = builder.profileVersion
    /**
     * The time when the signature of a signing job expires.
     */
    public val signatureExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.signatureExpiresAt
    /**
     * A `SignedObject` structure that contains information about a signing job's signed code image.
     */
    public val signedObject: aws.sdk.kotlin.services.signer.model.SignedObject? = builder.signedObject
    /**
     * A `SigningMaterial` object that contains the Amazon Resource Name (ARN) of the certificate used for the signing job.
     */
    public val signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = builder.signingMaterial
    /**
     * A `Source` that contains information about a signing job's code image source.
     */
    public val source: aws.sdk.kotlin.services.signer.model.Source? = builder.source
    /**
     * The status of the signing job.
     */
    public val status: aws.sdk.kotlin.services.signer.model.SigningStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.SigningJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SigningJob(")
        append("createdAt=$createdAt,")
        append("isRevoked=$isRevoked,")
        append("jobId=$jobId,")
        append("jobInvoker=$jobInvoker,")
        append("jobOwner=$jobOwner,")
        append("platformDisplayName=$platformDisplayName,")
        append("platformId=$platformId,")
        append("profileName=$profileName,")
        append("profileVersion=$profileVersion,")
        append("signatureExpiresAt=$signatureExpiresAt,")
        append("signedObject=$signedObject,")
        append("signingMaterial=$signingMaterial,")
        append("source=$source,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (isRevoked.hashCode())
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobInvoker?.hashCode() ?: 0)
        result = 31 * result + (jobOwner?.hashCode() ?: 0)
        result = 31 * result + (platformDisplayName?.hashCode() ?: 0)
        result = 31 * result + (platformId?.hashCode() ?: 0)
        result = 31 * result + (profileName?.hashCode() ?: 0)
        result = 31 * result + (profileVersion?.hashCode() ?: 0)
        result = 31 * result + (signatureExpiresAt?.hashCode() ?: 0)
        result = 31 * result + (signedObject?.hashCode() ?: 0)
        result = 31 * result + (signingMaterial?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SigningJob

        if (createdAt != other.createdAt) return false
        if (isRevoked != other.isRevoked) return false
        if (jobId != other.jobId) return false
        if (jobInvoker != other.jobInvoker) return false
        if (jobOwner != other.jobOwner) return false
        if (platformDisplayName != other.platformDisplayName) return false
        if (platformId != other.platformId) return false
        if (profileName != other.profileName) return false
        if (profileVersion != other.profileVersion) return false
        if (signatureExpiresAt != other.signatureExpiresAt) return false
        if (signedObject != other.signedObject) return false
        if (signingMaterial != other.signingMaterial) return false
        if (source != other.source) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.SigningJob = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that the signing job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the signing job is revoked.
         */
        public var isRevoked: kotlin.Boolean = false
        /**
         * The ID of the signing job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The AWS account ID of the job invoker.
         */
        public var jobInvoker: kotlin.String? = null
        /**
         * The AWS account ID of the job owner.
         */
        public var jobOwner: kotlin.String? = null
        /**
         * The name of a signing platform.
         */
        public var platformDisplayName: kotlin.String? = null
        /**
         * The unique identifier for a signing platform.
         */
        public var platformId: kotlin.String? = null
        /**
         * The name of the signing profile that created a signing job.
         */
        public var profileName: kotlin.String? = null
        /**
         * The version of the signing profile that created a signing job.
         */
        public var profileVersion: kotlin.String? = null
        /**
         * The time when the signature of a signing job expires.
         */
        public var signatureExpiresAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A `SignedObject` structure that contains information about a signing job's signed code image.
         */
        public var signedObject: aws.sdk.kotlin.services.signer.model.SignedObject? = null
        /**
         * A `SigningMaterial` object that contains the Amazon Resource Name (ARN) of the certificate used for the signing job.
         */
        public var signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = null
        /**
         * A `Source` that contains information about a signing job's code image source.
         */
        public var source: aws.sdk.kotlin.services.signer.model.Source? = null
        /**
         * The status of the signing job.
         */
        public var status: aws.sdk.kotlin.services.signer.model.SigningStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.SigningJob) : this() {
            this.createdAt = x.createdAt
            this.isRevoked = x.isRevoked
            this.jobId = x.jobId
            this.jobInvoker = x.jobInvoker
            this.jobOwner = x.jobOwner
            this.platformDisplayName = x.platformDisplayName
            this.platformId = x.platformId
            this.profileName = x.profileName
            this.profileVersion = x.profileVersion
            this.signatureExpiresAt = x.signatureExpiresAt
            this.signedObject = x.signedObject
            this.signingMaterial = x.signingMaterial
            this.source = x.source
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.SigningJob = SigningJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SignedObject] inside the given [block]
         */
        public fun signedObject(block: aws.sdk.kotlin.services.signer.model.SignedObject.Builder.() -> kotlin.Unit) {
            this.signedObject = aws.sdk.kotlin.services.signer.model.SignedObject.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningMaterial] inside the given [block]
         */
        public fun signingMaterial(block: aws.sdk.kotlin.services.signer.model.SigningMaterial.Builder.() -> kotlin.Unit) {
            this.signingMaterial = aws.sdk.kotlin.services.signer.model.SigningMaterial.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.Source] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.signer.model.Source.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.signer.model.Source.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
