// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the Amazon S3 bucket where you saved your unsigned code.
 */
public class S3Source private constructor(builder: Builder) {
    /**
     * Name of the S3 bucket.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * Key name of the bucket object that contains your unsigned code.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * Version of your source image in your version enabled S3 bucket.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.S3Source = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Source(")
        append("bucketName=$bucketName,")
        append("key=$key,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (key.hashCode())
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Source

        if (bucketName != other.bucketName) return false
        if (key != other.key) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.S3Source = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of the S3 bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * Key name of the bucket object that contains your unsigned code.
         */
        public var key: kotlin.String? = null
        /**
         * Version of your source image in your version enabled S3 bucket.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.S3Source) : this() {
            this.bucketName = x.bucketName
            this.key = x.key
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.S3Source = S3Source(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (key == null) key = ""
            if (version == null) version = ""
            return this
        }
    }
}
