// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetRevocationStatusRequest private constructor(builder: Builder) {
    /**
     * A list of composite signed hashes that identify certificates.
     *
     * A certificate identifier consists of a subject certificate TBS hash (signed by the parent CA) combined with a parent CA TBS hash (signed by the parent CA’s CA). Root certificates are defined as their own CA.
     *
     * The following example shows how to calculate a hash for this parameter using OpenSSL commands:
     *
     * `openssl asn1parse -in childCert.pem -strparse 4 -out childCert.tbs`
     *
     * `openssl sha384 < childCert.tbs -binary > childCertTbsHash`
     *
     * `openssl asn1parse -in parentCert.pem -strparse 4 -out parentCert.tbs`
     *
     * `openssl sha384 < parentCert.tbs -binary > parentCertTbsHash xxd -p childCertTbsHash > certificateHash.hex xxd -p parentCertTbsHash >> certificateHash.hex`
     *
     * `cat certificateHash.hex | tr -d '\n'`
     */
    public val certificateHashes: List<String>? = builder.certificateHashes
    /**
     * The ARN of a signing job.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The ID of a signing platform.
     */
    public val platformId: kotlin.String? = builder.platformId
    /**
     * The version of a signing profile.
     */
    public val profileVersionArn: kotlin.String? = builder.profileVersionArn
    /**
     * The timestamp of the signature that validates the profile or job.
     */
    public val signatureTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.signatureTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.GetRevocationStatusRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRevocationStatusRequest(")
        append("certificateHashes=$certificateHashes,")
        append("jobArn=$jobArn,")
        append("platformId=$platformId,")
        append("profileVersionArn=$profileVersionArn,")
        append("signatureTimestamp=$signatureTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateHashes?.hashCode() ?: 0
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (platformId?.hashCode() ?: 0)
        result = 31 * result + (profileVersionArn?.hashCode() ?: 0)
        result = 31 * result + (signatureTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRevocationStatusRequest

        if (certificateHashes != other.certificateHashes) return false
        if (jobArn != other.jobArn) return false
        if (platformId != other.platformId) return false
        if (profileVersionArn != other.profileVersionArn) return false
        if (signatureTimestamp != other.signatureTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.GetRevocationStatusRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of composite signed hashes that identify certificates.
         *
         * A certificate identifier consists of a subject certificate TBS hash (signed by the parent CA) combined with a parent CA TBS hash (signed by the parent CA’s CA). Root certificates are defined as their own CA.
         *
         * The following example shows how to calculate a hash for this parameter using OpenSSL commands:
         *
         * `openssl asn1parse -in childCert.pem -strparse 4 -out childCert.tbs`
         *
         * `openssl sha384 < childCert.tbs -binary > childCertTbsHash`
         *
         * `openssl asn1parse -in parentCert.pem -strparse 4 -out parentCert.tbs`
         *
         * `openssl sha384 < parentCert.tbs -binary > parentCertTbsHash xxd -p childCertTbsHash > certificateHash.hex xxd -p parentCertTbsHash >> certificateHash.hex`
         *
         * `cat certificateHash.hex | tr -d '\n'`
         */
        public var certificateHashes: List<String>? = null
        /**
         * The ARN of a signing job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The ID of a signing platform.
         */
        public var platformId: kotlin.String? = null
        /**
         * The version of a signing profile.
         */
        public var profileVersionArn: kotlin.String? = null
        /**
         * The timestamp of the signature that validates the profile or job.
         */
        public var signatureTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.GetRevocationStatusRequest) : this() {
            this.certificateHashes = x.certificateHashes
            this.jobArn = x.jobArn
            this.platformId = x.platformId
            this.profileVersionArn = x.profileVersionArn
            this.signatureTimestamp = x.signatureTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.GetRevocationStatusRequest = GetRevocationStatusRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
