// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Any overrides that are applied to the signing configuration of a signing platform.
 */
public class SigningPlatformOverrides private constructor(builder: Builder) {
    /**
     * A signing configuration that overrides the default encryption or hash algorithm of a signing job.
     */
    public val signingConfiguration: aws.sdk.kotlin.services.signer.model.SigningConfigurationOverrides? = builder.signingConfiguration
    /**
     * A signed image is a JSON object. When overriding the default signing platform configuration, a customer can select either of two signing formats, `JSONEmbedded` or `JSONDetached`. (A third format value, `JSON`, is reserved for future use.) With `JSONEmbedded`, the signing image has the payload embedded in it. With `JSONDetached`, the payload is not be embedded in the signing image.
     */
    public val signingImageFormat: aws.sdk.kotlin.services.signer.model.ImageFormat? = builder.signingImageFormat

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SigningPlatformOverrides(")
        append("signingConfiguration=$signingConfiguration,")
        append("signingImageFormat=$signingImageFormat")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = signingConfiguration?.hashCode() ?: 0
        result = 31 * result + (signingImageFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SigningPlatformOverrides

        if (signingConfiguration != other.signingConfiguration) return false
        if (signingImageFormat != other.signingImageFormat) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A signing configuration that overrides the default encryption or hash algorithm of a signing job.
         */
        public var signingConfiguration: aws.sdk.kotlin.services.signer.model.SigningConfigurationOverrides? = null
        /**
         * A signed image is a JSON object. When overriding the default signing platform configuration, a customer can select either of two signing formats, `JSONEmbedded` or `JSONDetached`. (A third format value, `JSON`, is reserved for future use.) With `JSONEmbedded`, the signing image has the payload embedded in it. With `JSONDetached`, the payload is not be embedded in the signing image.
         */
        public var signingImageFormat: aws.sdk.kotlin.services.signer.model.ImageFormat? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides) : this() {
            this.signingConfiguration = x.signingConfiguration
            this.signingImageFormat = x.signingImageFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides = SigningPlatformOverrides(this)

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningConfigurationOverrides] inside the given [block]
         */
        public fun signingConfiguration(block: aws.sdk.kotlin.services.signer.model.SigningConfigurationOverrides.Builder.() -> kotlin.Unit) {
            this.signingConfiguration = aws.sdk.kotlin.services.signer.model.SigningConfigurationOverrides.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
