// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The hash algorithms that are available to a code-signing job.
 */
public class HashAlgorithmOptions private constructor(builder: Builder) {
    /**
     * The set of accepted hash algorithms allowed in a code-signing job.
     */
    public val allowedValues: List<HashAlgorithm> = requireNotNull(builder.allowedValues) { "A non-null value must be provided for allowedValues" }
    /**
     * The default hash algorithm that is used in a code-signing job.
     */
    public val defaultValue: aws.sdk.kotlin.services.signer.model.HashAlgorithm = requireNotNull(builder.defaultValue) { "A non-null value must be provided for defaultValue" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.HashAlgorithmOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HashAlgorithmOptions(")
        append("allowedValues=$allowedValues,")
        append("defaultValue=$defaultValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues.hashCode()
        result = 31 * result + (defaultValue.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HashAlgorithmOptions

        if (allowedValues != other.allowedValues) return false
        if (defaultValue != other.defaultValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.HashAlgorithmOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The set of accepted hash algorithms allowed in a code-signing job.
         */
        public var allowedValues: List<HashAlgorithm>? = null
        /**
         * The default hash algorithm that is used in a code-signing job.
         */
        public var defaultValue: aws.sdk.kotlin.services.signer.model.HashAlgorithm? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.HashAlgorithmOptions) : this() {
            this.allowedValues = x.allowedValues
            this.defaultValue = x.defaultValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.HashAlgorithmOptions = HashAlgorithmOptions(this)

        internal fun correctErrors(): Builder {
            if (allowedValues == null) allowedValues = emptyList()
            if (defaultValue == null) defaultValue = HashAlgorithm.SdkUnknown("no value provided")
            return this
        }
    }
}
