// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.serde

import aws.sdk.kotlin.services.signer.model.GetSigningProfileResponse
import aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod
import aws.sdk.kotlin.services.signer.model.SignerException
import aws.sdk.kotlin.services.signer.model.SigningMaterial
import aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides
import aws.sdk.kotlin.services.signer.model.SigningProfileRevocationRecord
import aws.sdk.kotlin.services.signer.model.SigningProfileStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetSigningProfileOperationDeserializer: HttpDeserializer.NonStreaming<GetSigningProfileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSigningProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSigningProfileError(context, call, payload)
        }
        val builder = GetSigningProfileResponse.Builder()

        if (payload != null) {
            deserializeGetSigningProfileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSigningProfileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SignerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SignerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSigningProfileOperationBody(builder: GetSigningProfileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val OVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("overrides"))
    val PLATFORMDISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("platformDisplayName"))
    val PLATFORMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("platformId"))
    val PROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("profileName"))
    val PROFILEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("profileVersion"))
    val PROFILEVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("profileVersionArn"))
    val REVOCATIONRECORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("revocationRecord"))
    val SIGNATUREVALIDITYPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("signatureValidityPeriod"))
    val SIGNINGMATERIAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("signingMaterial"))
    val SIGNINGPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("signingParameters"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(OVERRIDES_DESCRIPTOR)
        field(PLATFORMDISPLAYNAME_DESCRIPTOR)
        field(PLATFORMID_DESCRIPTOR)
        field(PROFILENAME_DESCRIPTOR)
        field(PROFILEVERSION_DESCRIPTOR)
        field(PROFILEVERSIONARN_DESCRIPTOR)
        field(REVOCATIONRECORD_DESCRIPTOR)
        field(SIGNATUREVALIDITYPERIOD_DESCRIPTOR)
        field(SIGNINGMATERIAL_DESCRIPTOR)
        field(SIGNINGPARAMETERS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                OVERRIDES_DESCRIPTOR.index -> builder.overrides = deserializeSigningPlatformOverridesDocument(deserializer)
                PLATFORMDISPLAYNAME_DESCRIPTOR.index -> builder.platformDisplayName = deserializeString()
                PLATFORMID_DESCRIPTOR.index -> builder.platformId = deserializeString()
                PROFILENAME_DESCRIPTOR.index -> builder.profileName = deserializeString()
                PROFILEVERSION_DESCRIPTOR.index -> builder.profileVersion = deserializeString()
                PROFILEVERSIONARN_DESCRIPTOR.index -> builder.profileVersionArn = deserializeString()
                REVOCATIONRECORD_DESCRIPTOR.index -> builder.revocationRecord = deserializeSigningProfileRevocationRecordDocument(deserializer)
                SIGNATUREVALIDITYPERIOD_DESCRIPTOR.index -> builder.signatureValidityPeriod = deserializeSignatureValidityPeriodDocument(deserializer)
                SIGNINGMATERIAL_DESCRIPTOR.index -> builder.signingMaterial = deserializeSigningMaterialDocument(deserializer)
                SIGNINGPARAMETERS_DESCRIPTOR.index -> builder.signingParameters =
                    deserializer.deserializeMap(SIGNINGPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SigningProfileStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
