// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.serde

import aws.sdk.kotlin.services.signer.model.DescribeSigningJobResponse
import aws.sdk.kotlin.services.signer.model.SignedObject
import aws.sdk.kotlin.services.signer.model.SignerException
import aws.sdk.kotlin.services.signer.model.SigningJobRevocationRecord
import aws.sdk.kotlin.services.signer.model.SigningMaterial
import aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides
import aws.sdk.kotlin.services.signer.model.SigningStatus
import aws.sdk.kotlin.services.signer.model.Source
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class DescribeSigningJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeSigningJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeSigningJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeSigningJobError(context, call, payload)
        }
        val builder = DescribeSigningJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeSigningJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeSigningJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SignerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SignerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSigningJobOperationBody(builder: DescribeSigningJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPLETEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("completedAt"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobId"))
    val JOBINVOKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobInvoker"))
    val JOBOWNER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobOwner"))
    val OVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("overrides"))
    val PLATFORMDISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("platformDisplayName"))
    val PLATFORMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("platformId"))
    val PROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("profileName"))
    val PROFILEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("profileVersion"))
    val REQUESTEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestedBy"))
    val REVOCATIONRECORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("revocationRecord"))
    val SIGNATUREEXPIRESAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("signatureExpiresAt"))
    val SIGNEDOBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("signedObject"))
    val SIGNINGMATERIAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("signingMaterial"))
    val SIGNINGPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("signingParameters"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("source"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPLETEDAT_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBINVOKER_DESCRIPTOR)
        field(JOBOWNER_DESCRIPTOR)
        field(OVERRIDES_DESCRIPTOR)
        field(PLATFORMDISPLAYNAME_DESCRIPTOR)
        field(PLATFORMID_DESCRIPTOR)
        field(PROFILENAME_DESCRIPTOR)
        field(PROFILEVERSION_DESCRIPTOR)
        field(REQUESTEDBY_DESCRIPTOR)
        field(REVOCATIONRECORD_DESCRIPTOR)
        field(SIGNATUREEXPIRESAT_DESCRIPTOR)
        field(SIGNEDOBJECT_DESCRIPTOR)
        field(SIGNINGMATERIAL_DESCRIPTOR)
        field(SIGNINGPARAMETERS_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPLETEDAT_DESCRIPTOR.index -> builder.completedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBINVOKER_DESCRIPTOR.index -> builder.jobInvoker = deserializeString()
                JOBOWNER_DESCRIPTOR.index -> builder.jobOwner = deserializeString()
                OVERRIDES_DESCRIPTOR.index -> builder.overrides = deserializeSigningPlatformOverridesDocument(deserializer)
                PLATFORMDISPLAYNAME_DESCRIPTOR.index -> builder.platformDisplayName = deserializeString()
                PLATFORMID_DESCRIPTOR.index -> builder.platformId = deserializeString()
                PROFILENAME_DESCRIPTOR.index -> builder.profileName = deserializeString()
                PROFILEVERSION_DESCRIPTOR.index -> builder.profileVersion = deserializeString()
                REQUESTEDBY_DESCRIPTOR.index -> builder.requestedBy = deserializeString()
                REVOCATIONRECORD_DESCRIPTOR.index -> builder.revocationRecord = deserializeSigningJobRevocationRecordDocument(deserializer)
                SIGNATUREEXPIRESAT_DESCRIPTOR.index -> builder.signatureExpiresAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                SIGNEDOBJECT_DESCRIPTOR.index -> builder.signedObject = deserializeSignedObjectDocument(deserializer)
                SIGNINGMATERIAL_DESCRIPTOR.index -> builder.signingMaterial = deserializeSigningMaterialDocument(deserializer)
                SIGNINGPARAMETERS_DESCRIPTOR.index -> builder.signingParameters =
                    deserializer.deserializeMap(SIGNINGPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeSourceDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SigningStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
