// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.paginators

import aws.sdk.kotlin.services.signer.SignerClient
import aws.sdk.kotlin.services.signer.model.ListSigningJobsRequest
import aws.sdk.kotlin.services.signer.model.ListSigningJobsResponse
import aws.sdk.kotlin.services.signer.model.ListSigningPlatformsRequest
import aws.sdk.kotlin.services.signer.model.ListSigningPlatformsResponse
import aws.sdk.kotlin.services.signer.model.ListSigningProfilesRequest
import aws.sdk.kotlin.services.signer.model.ListSigningProfilesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListSigningJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSigningJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSigningJobsResponse]
 */
public fun SignerClient.listSigningJobsPaginated(initialRequest: ListSigningJobsRequest = ListSigningJobsRequest { }): Flow<ListSigningJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSigningJobsPaginated.listSigningJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSigningJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSigningJobsResponse]
 */
public fun SignerClient.listSigningJobsPaginated(block: ListSigningJobsRequest.Builder.() -> Unit): Flow<ListSigningJobsResponse> =
    listSigningJobsPaginated(ListSigningJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSigningPlatformsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSigningPlatformsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSigningPlatformsResponse]
 */
public fun SignerClient.listSigningPlatformsPaginated(initialRequest: ListSigningPlatformsRequest = ListSigningPlatformsRequest { }): Flow<ListSigningPlatformsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSigningPlatformsPaginated.listSigningPlatforms(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSigningPlatformsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSigningPlatformsResponse]
 */
public fun SignerClient.listSigningPlatformsPaginated(block: ListSigningPlatformsRequest.Builder.() -> Unit): Flow<ListSigningPlatformsResponse> =
    listSigningPlatformsPaginated(ListSigningPlatformsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSigningProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSigningProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSigningProfilesResponse]
 */
public fun SignerClient.listSigningProfilesPaginated(initialRequest: ListSigningProfilesRequest = ListSigningProfilesRequest { }): Flow<ListSigningProfilesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSigningProfilesPaginated.listSigningProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSigningProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSigningProfilesResponse]
 */
public fun SignerClient.listSigningProfilesPaginated(block: ListSigningProfilesRequest.Builder.() -> Unit): Flow<ListSigningProfilesResponse> =
    listSigningProfilesPaginated(ListSigningProfilesRequest.Builder().apply(block).build())
