// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the signing configurations and parameters that are used to perform a code-signing job.
 */
public class SigningPlatform private constructor(builder: Builder) {
    /**
     * The category of a signing platform.
     */
    public val category: aws.sdk.kotlin.services.signer.model.Category? = builder.category
    /**
     * The display name of a signing platform.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The maximum size (in MB) of code that can be signed by a signing platform.
     */
    public val maxSizeInMb: kotlin.Int = builder.maxSizeInMb
    /**
     * Any partner entities linked to a signing platform.
     */
    public val partner: kotlin.String? = builder.partner
    /**
     * The ID of a signing platform.
     */
    public val platformId: kotlin.String? = builder.platformId
    /**
     * Indicates whether revocation is supported for the platform.
     */
    public val revocationSupported: kotlin.Boolean = builder.revocationSupported
    /**
     * The configuration of a signing platform. This includes the designated hash algorithm and encryption algorithm of a signing platform.
     */
    public val signingConfiguration: aws.sdk.kotlin.services.signer.model.SigningConfiguration? = builder.signingConfiguration
    /**
     * The image format of a AWS Signer platform or profile.
     */
    public val signingImageFormat: aws.sdk.kotlin.services.signer.model.SigningImageFormat? = builder.signingImageFormat
    /**
     * The types of targets that can be signed by a signing platform.
     */
    public val target: kotlin.String? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.SigningPlatform = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SigningPlatform(")
        append("category=$category,")
        append("displayName=$displayName,")
        append("maxSizeInMb=$maxSizeInMb,")
        append("partner=$partner,")
        append("platformId=$platformId,")
        append("revocationSupported=$revocationSupported,")
        append("signingConfiguration=$signingConfiguration,")
        append("signingImageFormat=$signingImageFormat,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (maxSizeInMb)
        result = 31 * result + (partner?.hashCode() ?: 0)
        result = 31 * result + (platformId?.hashCode() ?: 0)
        result = 31 * result + (revocationSupported.hashCode())
        result = 31 * result + (signingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (signingImageFormat?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SigningPlatform

        if (category != other.category) return false
        if (displayName != other.displayName) return false
        if (maxSizeInMb != other.maxSizeInMb) return false
        if (partner != other.partner) return false
        if (platformId != other.platformId) return false
        if (revocationSupported != other.revocationSupported) return false
        if (signingConfiguration != other.signingConfiguration) return false
        if (signingImageFormat != other.signingImageFormat) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.SigningPlatform = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The category of a signing platform.
         */
        public var category: aws.sdk.kotlin.services.signer.model.Category? = null
        /**
         * The display name of a signing platform.
         */
        public var displayName: kotlin.String? = null
        /**
         * The maximum size (in MB) of code that can be signed by a signing platform.
         */
        public var maxSizeInMb: kotlin.Int = 0
        /**
         * Any partner entities linked to a signing platform.
         */
        public var partner: kotlin.String? = null
        /**
         * The ID of a signing platform.
         */
        public var platformId: kotlin.String? = null
        /**
         * Indicates whether revocation is supported for the platform.
         */
        public var revocationSupported: kotlin.Boolean = false
        /**
         * The configuration of a signing platform. This includes the designated hash algorithm and encryption algorithm of a signing platform.
         */
        public var signingConfiguration: aws.sdk.kotlin.services.signer.model.SigningConfiguration? = null
        /**
         * The image format of a AWS Signer platform or profile.
         */
        public var signingImageFormat: aws.sdk.kotlin.services.signer.model.SigningImageFormat? = null
        /**
         * The types of targets that can be signed by a signing platform.
         */
        public var target: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.SigningPlatform) : this() {
            this.category = x.category
            this.displayName = x.displayName
            this.maxSizeInMb = x.maxSizeInMb
            this.partner = x.partner
            this.platformId = x.platformId
            this.revocationSupported = x.revocationSupported
            this.signingConfiguration = x.signingConfiguration
            this.signingImageFormat = x.signingImageFormat
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.SigningPlatform = SigningPlatform(this)

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningConfiguration] inside the given [block]
         */
        public fun signingConfiguration(block: aws.sdk.kotlin.services.signer.model.SigningConfiguration.Builder.() -> kotlin.Unit) {
            this.signingConfiguration = aws.sdk.kotlin.services.signer.model.SigningConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningImageFormat] inside the given [block]
         */
        public fun signingImageFormat(block: aws.sdk.kotlin.services.signer.model.SigningImageFormat.Builder.() -> kotlin.Unit) {
            this.signingImageFormat = aws.sdk.kotlin.services.signer.model.SigningImageFormat.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
