// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.signer.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetSigningProfileResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the signing profile.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A list of overrides applied by the target signing profile for signing operations.
     */
    public val overrides: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides? = builder.overrides
    /**
     * A human-readable name for the signing platform associated with the signing profile.
     */
    public val platformDisplayName: kotlin.String? = builder.platformDisplayName
    /**
     * The ID of the platform that is used by the target signing profile.
     */
    public val platformId: kotlin.String? = builder.platformId
    /**
     * The name of the target signing profile.
     */
    public val profileName: kotlin.String? = builder.profileName
    /**
     * The current version of the signing profile.
     */
    public val profileVersion: kotlin.String? = builder.profileVersion
    /**
     * The signing profile ARN, including the profile version.
     */
    public val profileVersionArn: kotlin.String? = builder.profileVersionArn
    /**
     * Revocation information for a signing profile.
     */
    public val revocationRecord: aws.sdk.kotlin.services.signer.model.SigningProfileRevocationRecord? = builder.revocationRecord
    /**
     * The validity period for a signing job.
     */
    public val signatureValidityPeriod: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod? = builder.signatureValidityPeriod
    /**
     * The ARN of the certificate that the target profile uses for signing operations.
     */
    public val signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = builder.signingMaterial
    /**
     * A map of key-value pairs for signing operations that is attached to the target signing profile.
     */
    public val signingParameters: Map<String, String>? = builder.signingParameters
    /**
     * The status of the target signing profile.
     */
    public val status: aws.sdk.kotlin.services.signer.model.SigningProfileStatus? = builder.status
    /**
     * Reason for the status of the target signing profile.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * A list of tags associated with the signing profile.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.signer.model.GetSigningProfileResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSigningProfileResponse(")
        append("arn=$arn,")
        append("overrides=$overrides,")
        append("platformDisplayName=$platformDisplayName,")
        append("platformId=$platformId,")
        append("profileName=$profileName,")
        append("profileVersion=$profileVersion,")
        append("profileVersionArn=$profileVersionArn,")
        append("revocationRecord=$revocationRecord,")
        append("signatureValidityPeriod=$signatureValidityPeriod,")
        append("signingMaterial=$signingMaterial,")
        append("signingParameters=$signingParameters,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (platformDisplayName?.hashCode() ?: 0)
        result = 31 * result + (platformId?.hashCode() ?: 0)
        result = 31 * result + (profileName?.hashCode() ?: 0)
        result = 31 * result + (profileVersion?.hashCode() ?: 0)
        result = 31 * result + (profileVersionArn?.hashCode() ?: 0)
        result = 31 * result + (revocationRecord?.hashCode() ?: 0)
        result = 31 * result + (signatureValidityPeriod?.hashCode() ?: 0)
        result = 31 * result + (signingMaterial?.hashCode() ?: 0)
        result = 31 * result + (signingParameters?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSigningProfileResponse

        if (arn != other.arn) return false
        if (overrides != other.overrides) return false
        if (platformDisplayName != other.platformDisplayName) return false
        if (platformId != other.platformId) return false
        if (profileName != other.profileName) return false
        if (profileVersion != other.profileVersion) return false
        if (profileVersionArn != other.profileVersionArn) return false
        if (revocationRecord != other.revocationRecord) return false
        if (signatureValidityPeriod != other.signatureValidityPeriod) return false
        if (signingMaterial != other.signingMaterial) return false
        if (signingParameters != other.signingParameters) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.signer.model.GetSigningProfileResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the signing profile.
         */
        public var arn: kotlin.String? = null
        /**
         * A list of overrides applied by the target signing profile for signing operations.
         */
        public var overrides: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides? = null
        /**
         * A human-readable name for the signing platform associated with the signing profile.
         */
        public var platformDisplayName: kotlin.String? = null
        /**
         * The ID of the platform that is used by the target signing profile.
         */
        public var platformId: kotlin.String? = null
        /**
         * The name of the target signing profile.
         */
        public var profileName: kotlin.String? = null
        /**
         * The current version of the signing profile.
         */
        public var profileVersion: kotlin.String? = null
        /**
         * The signing profile ARN, including the profile version.
         */
        public var profileVersionArn: kotlin.String? = null
        /**
         * Revocation information for a signing profile.
         */
        public var revocationRecord: aws.sdk.kotlin.services.signer.model.SigningProfileRevocationRecord? = null
        /**
         * The validity period for a signing job.
         */
        public var signatureValidityPeriod: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod? = null
        /**
         * The ARN of the certificate that the target profile uses for signing operations.
         */
        public var signingMaterial: aws.sdk.kotlin.services.signer.model.SigningMaterial? = null
        /**
         * A map of key-value pairs for signing operations that is attached to the target signing profile.
         */
        public var signingParameters: Map<String, String>? = null
        /**
         * The status of the target signing profile.
         */
        public var status: aws.sdk.kotlin.services.signer.model.SigningProfileStatus? = null
        /**
         * Reason for the status of the target signing profile.
         */
        public var statusReason: kotlin.String? = null
        /**
         * A list of tags associated with the signing profile.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.signer.model.GetSigningProfileResponse) : this() {
            this.arn = x.arn
            this.overrides = x.overrides
            this.platformDisplayName = x.platformDisplayName
            this.platformId = x.platformId
            this.profileName = x.profileName
            this.profileVersion = x.profileVersion
            this.profileVersionArn = x.profileVersionArn
            this.revocationRecord = x.revocationRecord
            this.signatureValidityPeriod = x.signatureValidityPeriod
            this.signingMaterial = x.signingMaterial
            this.signingParameters = x.signingParameters
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.signer.model.GetSigningProfileResponse = GetSigningProfileResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides] inside the given [block]
         */
        public fun overrides(block: aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides.Builder.() -> kotlin.Unit) {
            this.overrides = aws.sdk.kotlin.services.signer.model.SigningPlatformOverrides.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningProfileRevocationRecord] inside the given [block]
         */
        public fun revocationRecord(block: aws.sdk.kotlin.services.signer.model.SigningProfileRevocationRecord.Builder.() -> kotlin.Unit) {
            this.revocationRecord = aws.sdk.kotlin.services.signer.model.SigningProfileRevocationRecord.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod] inside the given [block]
         */
        public fun signatureValidityPeriod(block: aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod.Builder.() -> kotlin.Unit) {
            this.signatureValidityPeriod = aws.sdk.kotlin.services.signer.model.SignatureValidityPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.signer.model.SigningMaterial] inside the given [block]
         */
        public fun signingMaterial(block: aws.sdk.kotlin.services.signer.model.SigningMaterial.Builder.() -> kotlin.Unit) {
            this.signingMaterial = aws.sdk.kotlin.services.signer.model.SigningMaterial.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
